/*******************************************************************************
 * Copyright (c) 2008, 2012 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Schank (Attensity Europe GmbH) - initial API and implementation
 *******************************************************************************/
package org.eclipse.smila.http.client.test;

import junit.framework.TestCase;

import org.eclipse.smila.http.client.TaskManagerClientHelper;

/**
 * Test class for {@link TaskManagerClientHelper}.
 */
public class TestTaskManagerClientHelper extends TestCase {

  /** {@inheritDoc} */
  @Override
  protected void setUp() throws Exception {
    super.setUp();
  }

  /** {@inheritDoc} */
  @Override
  protected void tearDown() throws Exception {
    super.tearDown();
  }

  /**
   * Test method for
   * {@link org.eclipse.smila.http.client.TaskManagerClientHelper#getTaskRequestResource(java.lang.String)}.
   */
  public void testGetTaskResource() {
    assertEquals("/taskmanager/x/", TaskManagerClientHelper.getTaskRequestResource("x"));
  }

  /**
   * Test method for
   * {@link org.eclipse.smila.http.client.TaskManagerClientHelper#getTaskRequestForWorkerHostResource(java.lang.String, java.lang.String)}
   * .
   */
  public void testGetTaskForWorkerHostResource() {
    assertEquals("/taskmanager/x/?workerHost=y",
      TaskManagerClientHelper.getTaskRequestForWorkerHostResource("x", "y"));
  }

  /**
   * Test method for
   * {@link org.eclipse.smila.http.client.TaskManagerClientHelper#getInitialTaskRequestResource(java.lang.String, java.lang.String)}
   * .
   */
  public void testGetInitialTaskResource() {
    assertEquals("/taskmanager/x/initialTask/y/", TaskManagerClientHelper.getInitialTaskRequestResource("x", "y"));
  }

  /**
   * Test method for
   * {@link org.eclipse.smila.http.client.TaskManagerClientHelper#getTaskResource(java.lang.String, java.lang.String)}
   * .
   */
  public void testGetTaskFinishOrKeepAliveResource() {
    assertEquals("/taskmanager/x/y/", TaskManagerClientHelper.getTaskResource("x", "y"));
  }

}
