/*******************************************************************************
 * Copyright (c) 2008, 2012 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher (Attensity Europe GmbH) - initial API and implementation
 *******************************************************************************/
package org.eclipse.smila.http.client;

import java.io.Closeable;
import java.util.Iterator;

import org.eclipse.smila.datamodel.AnyMap;

/**
 * Interface for return type of {@link RestClient#getBulk(String, org.apache.http.params.HttpParams)} method. Usage is
 * simple: use the {@link #hasNext()} and {@link #next()} methods just like in collection iterators. You can also use
 * the complete object as an Iterable in a <tt>for</tt> loop. If you do not read the complete content in your code, make
 * sure to {@link #close()} the object when you do not need it anymore.
 */
public interface BulkResponse extends Iterable<AnyMap>, Iterator<AnyMap>, Closeable {

}
