/*******************************************************************************
 * Copyright (c) 2008, 2014 Empolis Information Management GmbH and brox IT Solutions GmbH. All rights reserved.
 * This program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors: Juergen Schumacher (Empolis Information Management GmbH) - initial API and implementation
 *******************************************************************************/
package org.eclipse.smila.http.client.impl;

import java.io.IOException;

import org.apache.http.HttpResponse;
import org.apache.http.client.AuthCache;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.ClientContext;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.eclipse.smila.http.client.impl.base.HttpRequestExecutor;

/** implementation used by {@link DefaultRestClient}. */
public class DefaultHttpRequestExecutor implements HttpRequestExecutor {

  /** the host and port we are talking to. */
  private final String _hostAndPort;

  /** prevent unnecessary repeation of requests due to required authorization. */
  private final AuthCache _authCache = new BasicAuthCache();

  /** create instance. */
  public DefaultHttpRequestExecutor(final String hostAndPort) {
    if (hostAndPort.toLowerCase().startsWith("http://")) {
      _hostAndPort = hostAndPort;
    } else {
      _hostAndPort = "http://" + hostAndPort;
    }
  }

  @Override
  public String getHostAndPort() {
    return _hostAndPort;
  }

  @Override
  public HttpResponse execute(final HttpClient client, final HttpUriRequest request) throws IOException {
    final HttpContext context = createHttpContext();
    return client.execute(request, context);
  }

  /** BasicHttpContext has to be created for each request, can't use an instance variable here. */
  private final HttpContext createHttpContext() {
    final BasicHttpContext context = new BasicHttpContext();
    context.setAttribute(ClientContext.AUTH_CACHE, _authCache);
    return context;
  }
}
