/*********************************************************************************************************************
 * Copyright (c) 2008, 2013 Empolis Information Management GmbH and brox IT Solutions GmbH. All rights reserved.
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 *********************************************************************************************************************/
package org.eclipse.smila.importing.crawler.feed;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

/** contains the feed (entry) properties constants. */
public abstract class FeedProperties {
  /** URL where the feed was read from. */
  public static final String FEED_SOURCE_URL = "feedSourceUrl";

  /** properties of the feed. */
  public static final String FEED_AUTHORS = "feedAuthors";

  public static final String FEED_CATEGORIES = "feedCategories";

  public static final String FEED_CONTRIBUTORS = "feedContributors";

  public static final String FEED_COPYRIGHT = "feedCopyright";

  public static final String FEED_DESCRIPTION = "feedDescription";

  public static final String FEED_ENCODING = "feedEncoding";

  public static final String FEED_TYPE = "feedType";

  public static final String FEED_IMAGE = "feedImage";

  public static final String FEED_LANGUAGE = "feedLanguage";

  public static final String FEED_LINKS = "feedLinks";

  public static final String FEED_PUBLISH_DATE = "feedPublishDate";

  public static final String FEED_TITLE = "feedTitle";

  public static final String FEED_URI = "feedUri";

  public static final Collection<String> FEED_PROPERTIES = Arrays.asList(FEED_AUTHORS, FEED_CATEGORIES,
    FEED_CONTRIBUTORS, FEED_COPYRIGHT, FEED_DESCRIPTION, FEED_ENCODING, FEED_TYPE, FEED_IMAGE, FEED_LANGUAGE,
    FEED_LINKS, FEED_PUBLISH_DATE, FEED_TITLE, FEED_URI);

  /** properties of a feed entry. */
  public static final String FEED_ENTRY_AUTHORS = "itemAuthors";

  public static final String FEED_ENTRY_CATEGORIES = "itemCategories";

  public static final String FEED_ENTRY_CONTENTS = "itemContents";

  public static final String FEED_ENTRY_CONTRIBUTORS = "itemContributors";

  public static final String FEED_ENTRY_DESCRIPTION = "itemDescription";

  public static final String FEED_ENTRY_ENCLOSURES = "itemEnclosures";

  public static final String FEED_ENTRY_LINKS = "itemLinks";

  public static final String FEED_ENTRY_PUBLISH_DATE = "itemPublishDate";

  public static final String FEED_ENTRY_TITLE = "itemTitle";

  public static final String FEED_ENTRY_URI = "itemUri";

  public static final String FEED_ENTRY_UPDATE_DATE = "itemUpdateDate";

  public static final Collection<String> FEED_ENTRY_PROPERTIES = Arrays.asList(FEED_ENTRY_AUTHORS,
    FEED_ENTRY_CATEGORIES, FEED_ENTRY_CONTENTS, FEED_ENTRY_CONTRIBUTORS, FEED_ENTRY_DESCRIPTION,
    FEED_ENTRY_ENCLOSURES, FEED_ENTRY_LINKS, FEED_ENTRY_PUBLISH_DATE, FEED_ENTRY_TITLE, FEED_ENTRY_URI,
    FEED_ENTRY_UPDATE_DATE);

  public static final Set<String> ALL_PROPS = new HashSet<>();

  static {
    ALL_PROPS.addAll(FEED_PROPERTIES);
    ALL_PROPS.addAll(FEED_ENTRY_PROPERTIES);
  }

}
