/*********************************************************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 **********************************************************************************************************************/
package org.eclipse.smila.importing.crawler.web.test;

import java.util.Collection;

import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.importing.ImportingConstants;
import org.eclipse.smila.importing.crawler.web.RecordProducer;
import org.eclipse.smila.importing.crawler.web.WebCrawlerConstants;
import org.eclipse.smila.importing.crawler.web.producer.DefaultRecordProducer;

/** Test for {@link DefaultRecordProducer} class. */
public class TestDefaultRecordProducer extends WebHelperTestBase {

  private DefaultRecordProducer _producer = new DefaultRecordProducer();

  @Override
  protected void setUp() throws Exception {
    super.setUp();
    _producer = (DefaultRecordProducer) getService(RecordProducer.class);
  }

  /** simple test for simple funcionality. */
  public void test() throws Exception {
    final Record r = DataFactory.DEFAULT.createRecord();
    r.getMetadata().put(_webCrawlingContext.getMapper().get(WebCrawlerConstants.ATTRIBUTE_URL).get(0),
      "http://www.example.com/index.html");
    _webCrawlingContext.getTaskParameters().put(ImportingConstants.TASK_PARAM_DATA_SOURCE, "test");
    final Collection<Record> result = _producer.produceRecords(r, _webCrawlingContext);
    assertEquals(1, result.size());
    final Record producedRecord = result.iterator().next();
    assertNotNull(producedRecord.getId());
    assertEquals("test", producedRecord.getSource());
    assertNotNull(producedRecord.getMetadata().getStringValue(ImportingConstants.ATTRIBUTE_DELTA_HASH));
  }
}
