/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher (Attensity Europe GmbH) - initial API and implementation
 *******************************************************************************/

package org.eclipse.smila.importing.crawler.web;

import java.io.IOException;

import org.eclipse.smila.objectstore.BadRequestException;
import org.eclipse.smila.objectstore.ObjectStoreException;
import org.eclipse.smila.utils.MaybeRecoverableException;

/** exceptions thrown by WebCrawler components. */
public class WebCrawlerException extends MaybeRecoverableException {

  /** serializable. */
  private static final long serialVersionUID = 1L;

  /** create instance. */
  public WebCrawlerException(final String message, final boolean recoverable) {
    super(message, recoverable);
  }

  /** create instance. */
  public WebCrawlerException(final String message, final Throwable cause, final boolean recoverable) {
    super(message, cause, recoverable);
  }

  /** create instance. */
  public WebCrawlerException(final String message, final Throwable cause) {
    super(message, cause, isRecoverableCause(cause));
  }

  /** create instance. */
  public WebCrawlerException(final String message) {
    super(message);
  }

  /** create instance. */
  public WebCrawlerException(final Throwable cause, final boolean recoverable) {
    super(cause, recoverable);
  }

  /** create instance. */
  public WebCrawlerException(final Throwable cause) {
    super(cause, isRecoverableCause(cause));
  }

  /** @return if cause is a {@link MaybeRecoverableException}, too, return it's recoverable flag. else false. */
  public static boolean isRecoverableCause(final Throwable cause) {
    if (cause instanceof IOException) {
      return true;
    }
    if (cause instanceof BadRequestException) {
      return false;
    }
    if (cause instanceof ObjectStoreException) {
      return true;
    }
    return MaybeRecoverableException.isRecoverableCause(cause);
  }
}
