/*********************************************************************************************************************
 * Copyright (c) 2008, 2013 Empolis Information Management GmbH and brox IT Solutions GmbH. All rights reserved.
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 *********************************************************************************************************************/
package org.eclipse.smila.importing.util.test;

import junit.framework.TestCase;

import org.eclipse.smila.importing.util.FilePathNormalizer;

/** Test for {@link FilePathNormalizer} class. */
public class TestFilePathNormalizer extends TestCase {
  
  /** test with linux style paths. */
  public void testGetNormalizedPathLinuxStyle() {
    final String expectedResult = "/temp/bla";
    assertEquals(expectedResult, FilePathNormalizer.getNormalizedPath("/temp/bla"));
    assertEquals(expectedResult, FilePathNormalizer.getNormalizedPath("\\temp\\bla"));
    assertEquals(expectedResult, FilePathNormalizer.getNormalizedPath("/temp/bla/"));                
  }
  
  /** test with windows style paths. */
  public void testGetNormalizedPathWindowsStyle() {
    final String expectedResult = "C:/temp/bla";
    assertEquals(expectedResult, FilePathNormalizer.getNormalizedPath("C:/temp/bla"));
    assertEquals(expectedResult, FilePathNormalizer.getNormalizedPath("C:\\temp\\bla"));
    assertEquals(expectedResult, FilePathNormalizer.getNormalizedPath("C:/temp/bla/"));                
  }

}
