/*******************************************************************************
 * Copyright (c) 2008, 2012 Empolis Information Management GmbH and brox IT Solutions GmbH. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher (Empolis Information Management GmbH) - initial API and implementation
 *******************************************************************************/
package org.eclipse.smila.jdbc.test;

import junit.framework.Test;
import junit.framework.TestSuite;

/**
 * Test suite for org.eclipse.smila.importing bundle.
 */
public final class AllTests {

  /** name of test bundle. */
  public static final String BUNDLE_ID = "org.eclipse.smila.jdbc.test";

  /** Private default Constructor to avoid instance creation. */
  private AllTests() {
  }

  /**
   * Creates test suite.
   */
  public static Test suite() {
    final TestSuite suite = new TestSuite("Tests for org.eclipse.smila.jdbc");
    suite.addTestSuite(TestJdbcProvider.class);
    suite.addTestSuite(TestJdbcAccessService.class);
    suite.addTestSuite(TestResultSetToAnyConverter.class);
    suite.addTestSuite(TestJdbcWriterService.class);
    suite.addTestSuite(TestJdbcLoggingPipelet.class);
    suite.addTestSuite(TestJdbcFetcherPipelet.class);
    suite.addTestSuite(TestJdbcSelectPipelet.class);
    return suite;
  }

}
