/*********************************************************************************************************************
 * Copyright (c) 2008, 2013 Empolis Information Management GmbH and brox IT Solutions GmbH. All rights reserved.
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 *********************************************************************************************************************/
package org.eclipse.smila.jdbc.test;

import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.Blackboard.Get;
import org.eclipse.smila.blackboard.BlackboardFactory;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.jdbc.JdbcFetcherPipelet;
import org.eclipse.smila.jdbc.JdbcLoggingPipelet;
import org.eclipse.smila.jdbc.JdbcProvider;
import org.eclipse.smila.jdbc.JdbcWriterService;
import org.eclipse.smila.processing.Pipelet;
import org.eclipse.smila.processing.PipeletTracker;
import org.eclipse.smila.processing.parameters.ParameterAccessor;
import org.eclipse.smila.test.DeclarativeServiceTestCase;

/** Test for {@link JdbcFetcherPipelet} class. */
public class TestJdbcFetcherPipelet extends DeclarativeServiceTestCase {

  private static final String DB_URL = "jdbc:derby:memory:testpipelet";

  private Blackboard _bb;

  private final AnyMap _dbProps = DataFactory.DEFAULT.createAnyMap();

  private JdbcLoggingPipelet _logger;

  private JdbcFetcherPipelet _fetcher;

  @Override
  protected void setUp() throws Exception {
    super.setUp();
    _bb = getService(BlackboardFactory.class).createTransientBlackboard();
    _dbProps.put(JdbcWriterService.DB_PROPERTY_USER_NAME, "user");
    _dbProps.put(JdbcWriterService.DB_PROPERTY_USER_PASSWORD, "password");
    final JdbcProvider provider = getService(JdbcProvider.class);
    TestJdbcWriterService.prepareConnection(provider, DB_URL);

    final PipeletTracker tracker = getService(PipeletTracker.class);
    Class<? extends Pipelet> pipeletClass = tracker.getRegisteredPipelets().get(JdbcLoggingPipelet.class.getName());
    _logger = (JdbcLoggingPipelet) pipeletClass.newInstance();
    pipeletClass = tracker.getRegisteredPipelets().get(JdbcFetcherPipelet.class.getName());
    _fetcher = (JdbcFetcherPipelet) pipeletClass.newInstance();

    final AnyMap config = DataFactory.DEFAULT.createAnyMap();
    config.put(JdbcLoggingPipelet.PARAM_DB_URL, DB_URL);
    config.put(JdbcLoggingPipelet.PARAM_DB_PROPS, _dbProps);
    _logger.configure(config);
    _fetcher.configure(config);
  }

  @Override
  protected void tearDown() throws Exception {
    super.tearDown();
  }

  public void testWriteRead() throws Exception {
    final AnyMap logRecord = _bb.getRecord("logRecord", Get.NEW).getMetadata();
    final AnyMap logParameters = logRecord.getMap(ParameterAccessor.DEFAULT_PARAMETERS_ATTRIBUTE, true);
    logParameters.put(JdbcLoggingPipelet.PARAM_STMT, "INSERT INTO entries (string1, string2) VALUES (?, ?)");
    logParameters.getSeq(JdbcLoggingPipelet.PARAM_VALUE_PATHS, true).add("Sub/Att_String1");
    logParameters.getSeq(JdbcLoggingPipelet.PARAM_VALUE_PATHS, true).add("Sub/Att_String2");
    logRecord.getMap("Sub", true).put("Att_String1", "hello");
    logRecord.getMap("Sub", true).put("Att_String2", "pipelet");
    _logger.process(_bb, new String[] { "logRecord" });

    final AnyMap fetchRecord = _bb.getRecord("fetchRecord", Get.NEW).getMetadata();
    final AnyMap fetchParameters = fetchRecord.getMap(ParameterAccessor.DEFAULT_PARAMETERS_ATTRIBUTE, true);
    fetchParameters.put(JdbcLoggingPipelet.PARAM_STMT, "SELECT * FROM entries WHERE string1=?");
    fetchParameters.getSeq(JdbcLoggingPipelet.PARAM_VALUE_PATHS, true).add("Sub/Att_String1");
    fetchRecord.getMap("Sub", true).put("Att_String1", "hello");
    final String[] resultIds = _fetcher.process(_bb, new String[] { "fetchRecord" });
    assertNotNull(resultIds);
    assertEquals(1, resultIds.length);
    assertEquals("fetchRecord", resultIds[0]);
    final AnyMap metadata = _bb.getRecord("fetchRecord", Get.EXISTING).getMetadata();
    assertNotNull(metadata);
    assertEquals("hello", metadata.getStringValue("STRING1"));
    assertEquals("pipelet", metadata.getStringValue("STRING2"));
  }

}
