/*******************************************************************************
 * Copyright (c) 2008, 2012 Empolis Information Management GmbH and brox IT Solutions GmbH. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher (Empolis Information Management GmbH) - initial API and implementation
 *******************************************************************************/
package org.eclipse.smila.jdbc.test;

import java.sql.Connection;
import java.util.Properties;

import org.eclipse.smila.jdbc.JdbcProvider;
import org.eclipse.smila.jdbc.internal.JdbcProviderImpl;
import org.eclipse.smila.test.DeclarativeServiceTestCase;

/** test {@link JdbcProviderImpl}. */
public class TestJdbcProvider extends DeclarativeServiceTestCase {
  private static final String DBSERVER = "dbserver";

  private static final String DBUSER = "user";

  private static final String DBPASSWORD = "password";

  /** test creating an in-memory derby DB giving user/password via Properties object. */
  public void testDerbyEmbeddedWithProperties() throws Exception {
    final JdbcProvider provider = getService(JdbcProvider.class);
    final Properties props = new Properties();
    props.put("user", "user");
    props.put("password", "user");
    final Connection conn = provider.getConnection("jdbc:derby:memory:testdb1;create=true", props);
    assertNotNull(conn);
    conn.close();
  }

  /** test creating an in-memory derby DB giving user/password via parameters. */
  public void testDerbyEmbeddedWithUserAndPassword() throws Exception {
    final JdbcProvider provider = getService(JdbcProvider.class);
    final Connection conn = provider.getConnection("jdbc:derby:memory:testdb2;create=true", DBUSER, DBPASSWORD);
    assertNotNull(conn);
    conn.close();
  }

  // add necessary driver jars to lib/ and Bundle-ClassPath of org.eclipse.smila.jdbc first and edit the constants to
  // make these tests run.

  public void skip_testPostgresql() throws Exception {
    final JdbcProvider provider = getService(JdbcProvider.class);
    final Connection conn =
      provider.getConnection("jdbc:postgresql://" + DBSERVER + "/postgres", DBUSER, DBPASSWORD);
    assertNotNull(conn);
    conn.close();
  }

  public void skip_testMsSqlServer() throws Exception {
    final JdbcProvider provider = getService(JdbcProvider.class);
    final Connection conn =
      provider.getConnection("jdbc:sqlserver://" + DBSERVER + ":1433;databaseName=test", DBUSER, DBPASSWORD);
    assertNotNull(conn);
    conn.close();
  }

  public void skip_testOracle() throws Exception {
    final JdbcProvider provider = getService(JdbcProvider.class);
    final Connection conn =
      provider.getConnection("jdbc:oracle:thin:@" + DBSERVER + ":1521:xe", DBUSER, DBPASSWORD);
    assertNotNull(conn);
    conn.close();
  }

  public void skip_testMySql() throws Exception {
    final JdbcProvider provider = getService(JdbcProvider.class);
    final Connection conn = provider.getConnection("jdbc:mysql://" + DBSERVER + ":3306/test", DBUSER, DBPASSWORD);
    assertNotNull(conn);
    conn.close();
  }
}
