/*******************************************************************************
 * Copyright (c) 2008, 2012 Empolis Information Management GmbH and brox IT Solutions GmbH. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Daniel Stucky (Empolis Information Management GmbH) - initial API and implementation
 *******************************************************************************/
package org.eclipse.smila.jdbc;

import java.util.Collections;
import java.util.List;

import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.Value;

public interface JdbcWriterService {

  String DB_PROPERTY_USER_NAME = "user";

  String DB_PROPERTY_USER_PASSWORD = "password";

  List<Value> NO_VALUES = Collections.emptyList();

  /**
   * Write a statement with values into a database.
   * 
   * @param dbUrl
   *          url to the jdbc database
   * @param dbProps
   *          properties for connecting to the database (e.g. user, password)
   * @param preparedStatement
   *          a SQL statement with prepared syntax to add values to
   * @param values
   *          a list of Any values to set in the prepared statement
   * @throws JdbcWriterServiceException
   */
  void write(final String dbUrl, final AnyMap dbProps, final String preparedStatement, final List<Value> values)
    throws JdbcWriterServiceException;
}
