/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors: Andreas Schank (Attensity Europe GmbH) - initial implementation
 **********************************************************************************************************************/
package org.eclipse.smila.jobmanager.test;

import junit.framework.Test;
import junit.framework.TestSuite;

import org.eclipse.smila.jobmanager.test.definitions.TestBucketDefinition;
import org.eclipse.smila.jobmanager.test.definitions.TestDataObjectTypeDefinition;
import org.eclipse.smila.jobmanager.test.definitions.TestDefinitionPersistence;
import org.eclipse.smila.jobmanager.test.definitions.TestJobDefinition;
import org.eclipse.smila.jobmanager.test.definitions.TestNonForkingWorkflows;
import org.eclipse.smila.jobmanager.test.definitions.TestParameterDefinition;
import org.eclipse.smila.jobmanager.test.definitions.TestWorkerDefinition;
import org.eclipse.smila.jobmanager.test.definitions.TestWorkflowDefinition;
import org.eclipse.smila.jobmanager.test.httphandler.TestBucketHandler;
import org.eclipse.smila.jobmanager.test.httphandler.TestDataObjectTypeHandler;
import org.eclipse.smila.jobmanager.test.httphandler.TestJobHandler;
import org.eclipse.smila.jobmanager.test.httphandler.TestWorkerHandler;
import org.eclipse.smila.jobmanager.test.httphandler.TestWorkflowHandler;
import org.eclipse.smila.jobmanager.test.httphandler.TestWorkflowRunControlHandler;
import org.eclipse.smila.jobmanager.test.taskgenerator.TestDefaultCompletionTasksGeneration;
import org.eclipse.smila.jobmanager.test.taskgenerator.TestRunOnceTriggerTaskGenerator;

/** Test suite combining all tests for org.eclipse.smila.jobmanager bundle. */
public final class AllTests {

  /** Utility class: private constructor to prevent instantiation. */
  private AllTests() {
    ; // nothing
  }

  /** @return Test suite combining all tests for org.eclipse.smila.jobmanager.persistence.objectstore bundle. */
  public static Test suite() {
    final TestSuite suite = new TestSuite(AllTests.class.getName());
    // $JUnit-BEGIN$
    suite.addTestSuite(TestWorkerSpecificParameters.class);
    suite.addTestSuite(TestDataObjectTypeDefinition.class);
    suite.addTestSuite(TestBucketDefinition.class);
    suite.addTestSuite(TestParameterDefinition.class);
    suite.addTestSuite(TestNonForkingWorkflows.class);
    suite.addTestSuite(TestWorkerDefinition.class);
    suite.addTestSuite(TestWorkflowDefinition.class);
    suite.addTestSuite(TestJobDefinition.class);
    suite.addTestSuite(TestDefinitionPersistence.class);
    suite.addTestSuite(TestJobManagerWithPersistence.class);
    suite.addTestSuite(TestValueExpression.class);
    suite.addTestSuite(TestTaskParameterUtils.class);
    suite.addTestSuite(TestJobListener.class);
    suite.addTestSuite(TestJobManagerException.class);
    suite.addTestSuite(TestJobManagerFinishTask.class);
    suite.addTestSuite(TestJobCanceling.class);
    suite.addTestSuite(TestWorkflowSimulation.class);
    suite.addTestSuite(TestWorkflowHandler.class);
    suite.addTestSuite(TestJobHandler.class);
    suite.addTestSuite(TestBucketHandler.class);
    suite.addTestSuite(TestDataObjectTypeHandler.class);
    suite.addTestSuite(TestWorkerHandler.class);
    suite.addTestSuite(TestComplexParametersInJob.class);
    suite.addTestSuite(TestParameterPriority.class);
    suite.addTestSuite(TestJobRunUsingStores.class);
    suite.addTestSuite(TestJobRunWatcher.class);
    suite.addTestSuite(TestRunOnceTriggerTaskGenerator.class);
    suite.addTestSuite(TestJobRunModes.class);
    suite.addTestSuite(TestJobDependsOnRunningJob.class);
    suite.addTestSuite(TestDefaultCompletionTasksGeneration.class);
    suite.addTestSuite(TestJobManagerJobCompletingWorkflowRun.class);
    suite.addTestSuite(TestBarrierJobs.class);
    suite.addTestSuite(TestJobManagerNonForkingWorkflow.class);
    suite.addTestSuite(TestWorkflowRunCanceling.class);
    suite.addTestSuite(TestWorkflowRunControlHandler.class);
    suite.addTestSuite(TestWorkflowRunInfo.class);
    suite.addTestSuite(TestJobRunFails.class);
    // $JUnit-END$
    return suite;
  }

}
