/**********************************************************************************************************************
 * Copyright (c) 2008, 2014 Empolis Information Management GmbH and brox IT Solutions GmbH. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors: Andreas Weber (Empolis Information Management GmbH) - initial implementation
 **********************************************************************************************************************/
package org.eclipse.smila.jobmanager.test;

import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.taskmanager.ResultDescription;
import org.eclipse.smila.taskmanager.Task;
import org.eclipse.smila.taskmanager.TaskCompletionStatus;
import org.eclipse.smila.taskmanager.TaskManager;

/**
 * Tests for Job Run Canceling.
 * 
 */
public class TestJobRunFails extends JobTaskProcessingTestBase {

  /** check that tasks are removed from taskmanager when job run failed. */
  public void testTasksAreRemoved() throws Exception {
    final String jobName = "testFail";
    final String workerParameterValue = "test";
    final String tempStoreName = "tempstore";
    final AnyMap parameters = createJobParameters(workerParameterValue, tempStoreName, tempStoreName);
    addJob(jobName, "testWorkflow", parameters);
    _objectStoreService.ensureStore(tempStoreName);
    final String jobRunId = startJob(jobName);
    assertJobRunning(jobName, jobRunId);

    final Task inputTask = _jobTaskProcessor.getInitialTask(WORKER_1, jobName);
    final Task intermediateTask =
      getSingleNextTask(inputTask, processInitialTask(inputTask, tempStoreName), WORKER_2);

    final ResultDescription errorResult = new ResultDescription(TaskCompletionStatus.FATAL_ERROR, null, null, null);
    final Task finishTaskForIntermediate =
      intermediateTask.createFinishTask(errorResult, TaskManager.FINISHING_TASKS_WORKER);
    _jobTaskProcessor.finishTask(finishTaskForIntermediate);
    _jobRunEngine.finishJob(jobName, jobRunId);

    final AnyMap jobRunData = assertJobRunFailed(jobName, jobRunId);
    assertWorkflowCounters(1, 0, 0, 1, 0, jobRunData);
    assertTaskCounters(2, 1, 0, 0, 1, 0, 0, jobRunData);
    // assert that tasks were removed from taskmanager:
    assertTaskManagerCounter(WORKER_1, 0, 0);
    assertTaskManagerCounter(WORKER_2, 0, 0);
  }

}
