/**********************************************************************************************
 * Copyright (c) 2008,2014 Empolis Information Management GmbH and brox IT Solutions GmbH. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * <ul>
 * <li>Andreas Weber (Empolis Information Management GmbH) - initial implementation</li>
 * </ul>
 **********************************************************************************************/
package org.eclipse.smila.jobmanager.test;

import junit.framework.TestCase;

import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.jobmanager.WorkflowRunInfo;

/**
 * Test for {@link WorkflowRunInfo} class.
 */
public class TestWorkflowRunInfo extends TestCase {

  public void test() {
    final String jobName = "jobX";
    final String jobRunId = "jobRun1";
    final String workflowRunId = "wfRun2";

    WorkflowRunInfo w = new WorkflowRunInfo(jobName, jobRunId, workflowRunId);
    assertEquals(jobName, w.getJobName());
    assertEquals(jobRunId, w.getJobId());
    assertEquals(workflowRunId, w.getWorkflowId());
  }

  public void testEquals() {
    final String jobName = "jobX";
    final String jobRunId = "jobRun1";
    final String workflowRunId = "wfRun2";

    WorkflowRunInfo w1 = new WorkflowRunInfo(jobName, jobRunId, workflowRunId);
    WorkflowRunInfo w2 = new WorkflowRunInfo(jobName, jobRunId, workflowRunId);
    assertEquals(w1, w2);
  }

  public void testToAny() {
    final String jobName = "jobX";
    final String jobRunId = "jobRun1";
    final String workflowRunId = "wfRun2";

    WorkflowRunInfo w = new WorkflowRunInfo(jobName, jobRunId, workflowRunId);
    final AnyMap wAny = w.toAny();
    assertEquals(jobName, wAny.getStringValue(WorkflowRunInfo.KEY_JOB_NAME));
    assertEquals(jobRunId, wAny.getStringValue(WorkflowRunInfo.KEY_JOB_RUN_ID));
    assertEquals(workflowRunId, wAny.getStringValue(WorkflowRunInfo.KEY_WORKFLOW_RUN_ID));
  }
}
