/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Schank (Attensity Europe GmbH) - initial implementation
 **********************************************************************************************************************/
package org.eclipse.smila.jobmanager.test.definitions;

import junit.framework.TestCase;

import org.eclipse.smila.common.definitions.AccessAny;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.jobmanager.definitions.WorkflowDefinition;

/**
 * Test if workflows are tagged as forking if they have buckets which serve as input for multiple following workers.
 * 
 * In all other cases they must be tagged as non-forking.
 */
public class TestNonForkingWorkflows extends TestCase {
  /**
   * Tests simple forking WF.
   * 
   * @throws Exception
   *           Any exception that happens.
   */
  public void testSimpleForking() throws Exception {
    final AnyMap workflowAny = AccessAny.FACTORY.createAnyMap();
    workflowAny.put("name", "fwf1");
    final AnyMap parametersAny = AccessAny.FACTORY.createAnyMap();
    parametersAny.put("indexName", "index");
    workflowAny.put("parameters", parametersAny);
    final AnySeq actionsAny = AccessAny.FACTORY.createAnySeq();
    {
      final AnyMap startActionAny = AccessAny.FACTORY.createAnyMap();
      startActionAny.put("worker", "startWorker");
      final AnyMap inputParametersAny = AccessAny.FACTORY.createAnyMap();
      inputParametersAny.put("index", "${indexName}");
      startActionAny.put("parameters", inputParametersAny);
      final AnyMap outputAny = AccessAny.FACTORY.createAnyMap();
      outputAny.put("output", "bucket1");
      startActionAny.put("output", outputAny);
      workflowAny.put("startAction", startActionAny);
    }
    {
      final AnyMap actionAny = AccessAny.FACTORY.createAnyMap();
      actionAny.put("worker", "secondWorker");
      final AnyMap inputParametersAny = AccessAny.FACTORY.createAnyMap();
      inputParametersAny.put("index", "${indexName}");
      actionAny.put("parameters", inputParametersAny);
      final AnyMap inputAny = AccessAny.FACTORY.createAnyMap();
      inputAny.put("inputBuckName", "bucket1");
      actionAny.put("input", inputAny);
      final AnyMap outputAny = AccessAny.FACTORY.createAnyMap();
      outputAny.put("outputBuckName", "bucket2");
      actionAny.put("output", outputAny);
      actionsAny.add(actionAny);
    }
    {
      final AnyMap actionAny = AccessAny.FACTORY.createAnyMap();
      actionAny.put("worker", "thirdWorker");
      final AnyMap inputParametersAny = AccessAny.FACTORY.createAnyMap();
      inputParametersAny.put("index", "${indexName}");
      actionAny.put("parameters", inputParametersAny);
      final AnyMap inputAny = AccessAny.FACTORY.createAnyMap();
      inputAny.put("inputBuckName", "bucket1");
      actionAny.put("input", inputAny);
      final AnyMap outputAny = AccessAny.FACTORY.createAnyMap();
      outputAny.put("outputBuckName", "bucket3");
      actionAny.put("output", outputAny);
      actionsAny.add(actionAny);
    }
    workflowAny.put("actions", actionsAny);
    final WorkflowDefinition def1 = new WorkflowDefinition(workflowAny);
    assertFalse(def1.isNonForking());
  }

  /**
   * Tests simple non-forking WF.
   * 
   * @throws Exception
   *           Any exception that happens.
   */
  public void testSimpleNonForking() throws Exception {
    final AnyMap workflowAny = AccessAny.FACTORY.createAnyMap();
    workflowAny.put("name", "fwf1");
    final AnyMap parametersAny = AccessAny.FACTORY.createAnyMap();
    parametersAny.put("indexName", "index");
    workflowAny.put("parameters", parametersAny);
    final AnySeq actionsAny = AccessAny.FACTORY.createAnySeq();
    {
      final AnyMap startActionAny = AccessAny.FACTORY.createAnyMap();
      startActionAny.put("worker", "startWorker");
      final AnyMap inputParametersAny = AccessAny.FACTORY.createAnyMap();
      inputParametersAny.put("index", "${indexName}");
      startActionAny.put("parameters", inputParametersAny);
      final AnyMap outputAny = AccessAny.FACTORY.createAnyMap();
      outputAny.put("output", "bucket1");
      startActionAny.put("output", outputAny);
      workflowAny.put("startAction", startActionAny);
    }
    {
      final AnyMap actionAny = AccessAny.FACTORY.createAnyMap();
      actionAny.put("worker", "secondWorker");
      final AnyMap inputParametersAny = AccessAny.FACTORY.createAnyMap();
      inputParametersAny.put("index", "${indexName}");
      actionAny.put("parameters", inputParametersAny);
      final AnyMap inputAny = AccessAny.FACTORY.createAnyMap();
      inputAny.put("inputBuckName", "bucket1");
      actionAny.put("input", inputAny);
      final AnyMap outputAny = AccessAny.FACTORY.createAnyMap();
      outputAny.put("outputBuckName", "bucket2");
      actionAny.put("output", outputAny);
      actionsAny.add(actionAny);
    }
    {
      final AnyMap actionAny = AccessAny.FACTORY.createAnyMap();
      actionAny.put("worker", "thirdWorker");
      final AnyMap inputParametersAny = AccessAny.FACTORY.createAnyMap();
      inputParametersAny.put("index", "${indexName}");
      actionAny.put("parameters", inputParametersAny);
      final AnyMap inputAny = AccessAny.FACTORY.createAnyMap();
      inputAny.put("inputBuckName", "bucket2");
      actionAny.put("input", inputAny);
      final AnyMap outputAny = AccessAny.FACTORY.createAnyMap();
      outputAny.put("outputBuckName", "bucket3");
      actionAny.put("output", outputAny);
      actionsAny.add(actionAny);
    }
    workflowAny.put("actions", actionsAny);
    final WorkflowDefinition def1 = new WorkflowDefinition(workflowAny);
    assertTrue(def1.isNonForking());
  }

  /**
   * Tests multi-input start action. (non-forking).
   * 
   * @throws Exception
   *           Any exception that happens.
   */
  public void testMultiInputStartAction() throws Exception {
    final AnyMap workflowAny = AccessAny.FACTORY.createAnyMap();
    workflowAny.put("name", "fwf1");
    final AnyMap parametersAny = AccessAny.FACTORY.createAnyMap();
    parametersAny.put("indexName", "index");
    workflowAny.put("parameters", parametersAny);
    final AnySeq actionsAny = AccessAny.FACTORY.createAnySeq();
    {
      final AnyMap startActionAny = AccessAny.FACTORY.createAnyMap();
      startActionAny.put("worker", "startWorker");
      final AnyMap inputParametersAny = AccessAny.FACTORY.createAnyMap();
      inputParametersAny.put("index", "${indexName}");
      startActionAny.put("parameters", inputParametersAny);
      final AnyMap inputAny = AccessAny.FACTORY.createAnyMap();
      inputAny.put("inputBuckName", "inputBucket1");
      inputAny.put("inputBuckName2", "inputBucket2");
      inputAny.put("inputBuckName3", "inputBucket3");
      startActionAny.put("input", inputAny);
      final AnyMap outputAny = AccessAny.FACTORY.createAnyMap();
      outputAny.put("output", "bucket1");
      startActionAny.put("output", outputAny);
      workflowAny.put("startAction", startActionAny);
    }
    workflowAny.put("actions", actionsAny);
    final WorkflowDefinition def1 = new WorkflowDefinition(workflowAny);
    assertTrue(def1.isNonForking());
  }

  /**
   * Tests multi-input start action with same bucket (non-forking).
   * 
   * @throws Exception
   *           Any exception that happens.
   */
  public void testRedundantMultiInputStartAction() throws Exception {
    final AnyMap workflowAny = AccessAny.FACTORY.createAnyMap();
    workflowAny.put("name", "fwf1");
    final AnyMap parametersAny = AccessAny.FACTORY.createAnyMap();
    parametersAny.put("indexName", "index");
    workflowAny.put("parameters", parametersAny);
    final AnySeq actionsAny = AccessAny.FACTORY.createAnySeq();
    {
      final AnyMap startActionAny = AccessAny.FACTORY.createAnyMap();
      startActionAny.put("worker", "startWorker");
      final AnyMap inputParametersAny = AccessAny.FACTORY.createAnyMap();
      inputParametersAny.put("index", "${indexName}");
      startActionAny.put("parameters", inputParametersAny);
      final AnyMap inputAny = AccessAny.FACTORY.createAnyMap();
      inputAny.put("inputBuckName", "inputBucket1");
      inputAny.put("inputBuckName2", "inputBucket1");
      inputAny.put("inputBuckName3", "inputBucket1");
      startActionAny.put("input", inputAny);
      final AnyMap outputAny = AccessAny.FACTORY.createAnyMap();
      outputAny.put("output", "bucket1");
      startActionAny.put("output", outputAny);
      workflowAny.put("startAction", startActionAny);
    }
    workflowAny.put("actions", actionsAny);
    final WorkflowDefinition def1 = new WorkflowDefinition(workflowAny);
    assertTrue(def1.isNonForking());
  }

  /**
   * Tests same input for multiple workers (forking).
   * 
   * @throws Exception
   *           Any exception that happens.
   */
  public void testRedundantMultiBucketOutLanes() throws Exception {
    final AnyMap workflowAny = AccessAny.FACTORY.createAnyMap();
    workflowAny.put("name", "fwf1");
    final AnyMap parametersAny = AccessAny.FACTORY.createAnyMap();
    parametersAny.put("indexName", "index");
    workflowAny.put("parameters", parametersAny);
    final AnySeq actionsAny = AccessAny.FACTORY.createAnySeq();
    {
      final AnyMap startActionAny = AccessAny.FACTORY.createAnyMap();
      startActionAny.put("worker", "startWorker");
      final AnyMap inputParametersAny = AccessAny.FACTORY.createAnyMap();
      inputParametersAny.put("index", "${indexName}");
      startActionAny.put("parameters", inputParametersAny);
      final AnyMap inputAny = AccessAny.FACTORY.createAnyMap();
      inputAny.put("inputBuckName", "inputBucket1");
      inputAny.put("inputBuckName2", "inputBucket1");
      inputAny.put("inputBuckName3", "inputBucket1");
      startActionAny.put("input", inputAny);
      final AnyMap outputAny = AccessAny.FACTORY.createAnyMap();
      outputAny.put("output", "bucket1");
      startActionAny.put("output", outputAny);
      workflowAny.put("startAction", startActionAny);
    }
    {
      final AnyMap actionAny = AccessAny.FACTORY.createAnyMap();
      actionAny.put("worker", "secondWorker");
      final AnyMap inputParametersAny = AccessAny.FACTORY.createAnyMap();
      inputParametersAny.put("index", "${indexName}");
      actionAny.put("parameters", inputParametersAny);
      final AnyMap inputAny = AccessAny.FACTORY.createAnyMap();
      inputAny.put("inputBuckName", "bucket1");
      actionAny.put("input", inputAny);
      final AnyMap outputAny = AccessAny.FACTORY.createAnyMap();
      outputAny.put("outputBuckName", "bucket2");
      actionAny.put("output", outputAny);
      actionsAny.add(actionAny);
    }
    {
      final AnyMap actionAny = AccessAny.FACTORY.createAnyMap();
      actionAny.put("worker", "thirdWorker");
      final AnyMap inputParametersAny = AccessAny.FACTORY.createAnyMap();
      inputParametersAny.put("index", "${indexName}");
      actionAny.put("parameters", inputParametersAny);
      final AnyMap inputAny = AccessAny.FACTORY.createAnyMap();
      inputAny.put("inputBuckName", "bucket2");
      actionAny.put("input", inputAny);
      final AnyMap outputAny = AccessAny.FACTORY.createAnyMap();
      outputAny.put("outputBuckName", "bucket3");
      actionAny.put("output", outputAny);
      actionsAny.add(actionAny);
    }
    {
      final AnyMap actionAny = AccessAny.FACTORY.createAnyMap();
      actionAny.put("worker", "fourthWorker");
      final AnyMap inputParametersAny = AccessAny.FACTORY.createAnyMap();
      inputParametersAny.put("index", "${indexName}");
      actionAny.put("parameters", inputParametersAny);
      final AnyMap inputAny = AccessAny.FACTORY.createAnyMap();
      inputAny.put("inputBuckName", "bucket2");
      actionAny.put("input", inputAny);
      final AnyMap outputAny = AccessAny.FACTORY.createAnyMap();
      outputAny.put("outputBuckName", "bucket4");
      actionAny.put("output", outputAny);
      actionsAny.add(actionAny);
    }
    {
      final AnyMap actionAny = AccessAny.FACTORY.createAnyMap();
      actionAny.put("worker", "fifthWorker");
      final AnyMap inputParametersAny = AccessAny.FACTORY.createAnyMap();
      inputParametersAny.put("index", "${indexName}");
      actionAny.put("parameters", inputParametersAny);
      final AnyMap inputAny = AccessAny.FACTORY.createAnyMap();
      inputAny.put("inputBuckName", "bucket2");
      actionAny.put("input", inputAny);
      final AnyMap outputAny = AccessAny.FACTORY.createAnyMap();
      outputAny.put("outputBuckName", "bucket4");
      actionAny.put("output", outputAny);
      actionsAny.add(actionAny);
    }

    workflowAny.put("actions", actionsAny);
    final WorkflowDefinition def1 = new WorkflowDefinition(workflowAny);
    assertFalse(def1.isNonForking());
  }
}
