/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Attensity Europe GmbH - initial implementation
 **********************************************************************************************************************/
package org.eclipse.smila.jobmanager.test.httphandler;

import java.net.HttpURLConnection;
import java.net.URL;

import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.http.server.util.RequestHandler;
import org.eclipse.smila.jobmanager.httphandler.WorkflowRunControlHandler;
import org.eclipse.smila.jobmanager.test.JobTaskProcessingTestBase;
import org.eclipse.smila.taskmanager.Task;

/**
 * Test cases for the {@link WorkflowRunControlHandler}.
 */
public class TestWorkflowRunControlHandler extends JobTaskProcessingTestBase {

  private WorkflowRunControlHandler _workflowRunControlHandler;

  @Override
  protected void setUp() throws Exception {
    super.setUp();
    RequestHandler service =
      getService(RequestHandler.class,
        "(uriPattern=/jobmanager/jobs/\\([^/]+\\)/\\([^/]+\\)/workflowrun/\\([^/]+\\)/\\([^/]+\\)/?$)");
    assertTrue(service instanceof WorkflowRunControlHandler);
    _workflowRunControlHandler = (WorkflowRunControlHandler) service;
  }

  /** test cancel workflow run via HTTP. */
  public void testCancelWorkflowRun() throws Exception {
    final String jobName = "testCancelWorkflowRun";
    final String workerParameterValue = "test";
    final String tempStoreName = "tempstore";
    final AnyMap parameters = createJobParameters(workerParameterValue, tempStoreName, tempStoreName);
    addJob(jobName, "testWorkflow", parameters);
    _objectStoreService.ensureStore(tempStoreName);
    final String jobRunId = startJob(jobName);
    // start workflow run
    final Task task_1 = _jobTaskProcessor.getInitialTask(WORKER_1, jobName);
    final String wfRun1 = task_1.getProperties().get(Task.PROPERTY_WORKFLOW_RUN_ID);

    // cancel workflow run via HTTP REST
    final String cancelPath =
      _workflowRunControlHandler.getRootContextPath() + "/jobmanager/jobs/" + jobName + "/" + jobRunId
        + "/workflowrun/" + wfRun1 + "/cancel";
    final URL cancelUrl = new URL("http://localhost:8080" + cancelPath);
    final HttpURLConnection cancelConnection = (HttpURLConnection) cancelUrl.openConnection();
    cancelConnection.setRequestMethod("POST");
    cancelConnection.connect();
    assertEquals(200, cancelConnection.getResponseCode());

    final AnyMap jobRunData = assertJobRunData(jobName, jobRunId);
    assertWorkflowCounters(1, 0, 0, 0, 1, jobRunData);
    assertTaskCounters(1, 0, 0, 0, 0, 0, 1, jobRunData);
  }

  /** check if an invalid command ("finish") is rejected. */
  public void testInvalidCommand() throws Exception {
    try {
      final Record r = DataFactory.DEFAULT.createRecord();
      _workflowRunControlHandler.process("POST", _workflowRunControlHandler.getRootContextPath()
        + "/jobmanager/jobs/jobname/jobrunid/workflowrun/wfrunid/finish", r);
      fail("should not work");
    } catch (final IllegalArgumentException ex) {
      ; // OK
    }
  }
}
