/*********************************************************************************************************************
 * Copyright (c) 2008, 2012 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 **********************************************************************************************************************/
package org.eclipse.smila.jobmanager.test.worker;

import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.taskmanager.Task;
import org.eclipse.smila.taskworker.TaskContext;
import org.eclipse.smila.taskworker.Worker;
import org.eclipse.smila.taskworker.input.Inputs;
import org.eclipse.smila.taskworker.input.RecordInput;
import org.eclipse.smila.taskworker.output.Outputs;
import org.eclipse.smila.taskworker.output.RecordOutput;

/**
 * Dummy test worker that reads a parameter and writes it to a record attribute.
 */
public class TestParametersWorker implements Worker {

  public static final String NAME = "testParametersWorker";

  public static final String INPUT_PARAMETER = "inParam";

  public static final String OUTPUT_ATTRIBUTE = "outAtt1";

  public static final String INPUT_SLOT_NAME = "input";

  public static final String OUTPUT_SLOT_NAME = "output";

  @Override
  public void perform(TaskContext taskContext) throws Exception {
    final Task task = taskContext.getTask();
    final AnyMap taskParams = task.getParameters();
    try {
      final Inputs inputs = taskContext.getInputs();
      final RecordInput recordInput = inputs.getAsRecordInput(INPUT_SLOT_NAME);
      final Outputs outputs = taskContext.getOutputs();
      final RecordOutput recordOutput = outputs.getAsRecordOutput(OUTPUT_SLOT_NAME);
      Record record = recordInput.getRecord();
      while (record != null) {
        try {
          final String val = taskParams.getStringValue(INPUT_PARAMETER);
          record.getMetadata().getSeq(OUTPUT_ATTRIBUTE, true).add(val);
          recordOutput.writeRecord(record);
          record = recordInput.getRecord();
        } catch (final Exception e) {
          record = null;
        }
      }
    } catch (final Exception e) {
      e.printStackTrace();
    }
  }

  @Override
  public String getName() {
    return NAME;
  }

}
