/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher, Andreas Weber, Drazen Cindric, Andreas Schank (all Attensity Europe GmbH) - initial
 * implementation
 **********************************************************************************************************************/
package org.eclipse.smila.jobmanager;

/**
 * Job lifecycle states.
 */
public enum JobState {
  /** started but not running yet. */
  PREPARING,
  /** running. */
  RUNNING,
  /** finished but not yet completing. */
  FINISHING,
  /** completing job run (completion tasks may be run) but not done yet. */
  COMPLETING,
  /** cleaning up job run. */
  CLEANINGUP,
  /** successfully completed and cleaned up. */
  SUCCEEDED,
  /** failed. */
  FAILED,
  /** cancellation has started but not yet finished. */
  CANCELLING,
  /** cancellation has finished. */
  CANCELED;

}
