/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Schank (Attensity Europe GmbH) - initial implementation
 **********************************************************************************************************************/

package org.eclipse.smila.objectstore.filesystem.test;

import junit.framework.Test;
import junit.framework.TestSuite;

/**
 * Suite combining the tests for the Eclipse SMILA filesystem implementation of an ObjectStoreService.
 * 
 */
public final class AllTests {

  /**
   * utility class, do not create instances.
   */
  private AllTests() {
    ; // nothing
  }

  /**
   * @return the test suite containing all tests for the o.e.s.objectstore.filesystem bundle.
   */
  public static Test suite() {
    final TestSuite suite = new TestSuite(AllTests.class.getName());
    // $JUnit-BEGIN$
    suite.addTestSuite(TestSimpleObjectStoreService.class);
    suite.addTestSuite(TestConcurrentAccess.class);
    // $JUnit-END$
    return suite;
  }

}
