/*******************************************************************************
 * Copyright (c) 2008 empolis GmbH and brox IT Solutions GmbH. All rights reserved. This program and the accompanying
 * materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher (empolis GmbH) - initial API and implementation
 *******************************************************************************/

package org.eclipse.smila.processing.bpel.test;

/**
 * Test the (Super)SlowPipeline. This is useful to check timeout problems. You need to increase the pipeline.timeout in
 * processor.properties. Therefore it is not included in the default tests.
 * 
 * 
 * @author jschumacher
 * 
 */
public class TestSlowPipeline extends AWorkflowProcessorTest {
  /**
   * name of pipeline to test.
   */
  public static final String PIPELINE_NAME = "SuperSlowPipeline";

  /**
   * {@inheritDoc}
   * 
   * @see org.eclipse.smila.processing.bpel.test.AWorkflowProcessorTest#getPipelineName()
   */
  @Override
  protected String getPipelineName() {
    return PIPELINE_NAME;
  }

  /**
   * @throws Exception
   *           test fails
   */
  public void testRecords() throws Exception {
    final int noOfRecords = 2;
    final String[] recordIds = new String[noOfRecords];
    for (int i = 0; i < noOfRecords; i++) {
      recordIds[i] = createBlackboardRecord("source", "key" + i);
    }
    getProcessor().process(PIPELINE_NAME, getBlackboard(), recordIds);
  }
}
