/*********************************************************************************************************************
 * Copyright (c) 2008, 2013 Empolis Information Management GmbH and brox IT Solutions GmbH. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 **********************************************************************************************************************/
package org.eclipse.smila.processing.pipelets.xmlprocessing.test;

import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.io.IOUtils;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.processing.Pipelet;
import org.eclipse.smila.processing.pipelets.SourceType;
import org.eclipse.smila.processing.pipelets.test.ATransformationPipeletTest;
import org.eclipse.smila.processing.pipelets.xmlprocessing.XmlDocumentSplitterPipelet;
import org.eclipse.smila.processing.pipelets.xmlprocessing.XmlSplitterPipelet;

/**
 * Test for {@link XmlDocumentSplitterPipelet} class.
 */
public class TestXmlDocumentSplitterPipelet extends ATransformationPipeletTest {

  /** Constant for the xml document to split. */
  private static final String SPLIT_XML = "./configuration/data/split.xml";

  /** test splitting of single xml file in three records with input attribute. */
  public void testAttributeInput() throws Exception {
    final AnyMap configuration = createAttributesConfiguration();
    final String id = createBlackboardRecord("testSource", "testAttributes");
    getBlackboard().getMetadata(id).put("in", SPLIT_XML);
    doTest(configuration, id);
  }

  /** test splitting of single xml file in three records with input attachment. */
  public void testAttachmentInput() throws Exception {
    final AnyMap configuration = createAttachmentsAttributesConfiguration();
    final String id = createBlackboardRecord("testSource", "testAttachments");
    getBlackboard().setAttachment(id, "in", IOUtils.toByteArray(new FileInputStream(SPLIT_XML)));
    doTest(configuration, id);
  }

  /** tests error handling in case of single record failures. */
  public void testRobustness() throws Exception {
    final XmlDocumentSplitterPipelet pipelet = new XmlDocumentSplitterPipelet();
    final AnyMap configuration = createAttributesConfiguration();
    configuration.put(XmlSplitterPipelet.PROP_BEGIN_TAG_NAME, "document");
    configuration.put(XmlSplitterPipelet.PROP_END_TAG_NAME, "document");
    pipelet.configure(configuration);
    doRobustnessTest(pipelet, SourceType.ATTRIBUTE, SPLIT_XML, configuration, true, false);
    doRobustnessTest(pipelet, SourceType.ATTRIBUTE, SPLIT_XML, configuration, false, false);
  }

  /** do test and check the results. */
  private void doTest(final AnyMap configuration, final String id) throws Exception {
    final Pipelet pipelet = new XmlDocumentSplitterPipelet();
    final String[] recordIds = new String[] { id };
    getBlackboard().getMetadata(id).put("anAttribute", "aValue");

    configuration.put(XmlSplitterPipelet.PROP_BEGIN_TAG_NAME, "document");
    configuration.put(XmlSplitterPipelet.PROP_END_TAG_NAME, "document");
    pipelet.configure(configuration);

    final String[] splitIds = pipelet.process(getBlackboard(), recordIds);

    assertEquals(3, splitIds.length);
    final List<String> outs = new ArrayList<String>();
    for (final String splitId : splitIds) {
      final String outXml = getBlackboard().getMetadata(splitId).getStringValue("out");
      assertTrue(outXml.matches("<document>(.|\\s)*</document>"));
      assertTrue(outXml.contains("<docId>"));
      assertTrue(outXml.contains("<title>"));
      assertTrue(outXml.contains("<text>"));
      assertEquals(id, getBlackboard().getMetadata(splitId).getStringValue("_documentId"));
      assertEquals("aValue", getBlackboard().getMetadata(splitId).getStringValue("anAttribute"));
      assertFalse(outs.contains(outXml));
      outs.add(outXml);
    }
  }

}
