/***********************************************************************************************************************
 * Copyright (c) 2008 empolis GmbH and brox IT Solutions GmbH. All rights reserved. This program and the accompanying
 * materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Daniel Stucky (empolis GmbH - initial implementation
 **********************************************************************************************************************/
package org.eclipse.smila.processing.pipelets;

import java.io.File;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.processing.Pipelet;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.parameters.ParameterAccessor;
import org.eclipse.smila.processing.util.ProcessingConstants;
import org.eclipse.smila.processing.util.ResultCollector;

/**
 * This pipelet reads in a file described by a path attribute and sets the content as an attachment.
 */
public class FileReaderPipelet implements Pipelet {

  /**
   * Constant for the property pathAttribute.
   */
  public static final String PROPERTY_PATH_ATTRIBUTE = "pathAttribute";

  /**
   * Constant for the property contentAttachment.
   */
  public static final String PROPERTY_CONTENT_ATTACHMENT = "contentAttachment";

  /** The local log. */
  private final Log _log = LogFactory.getLog(getClass());

  /** the configuration. */
  private AnyMap _config;

  /**
   * {@inheritDoc}
   */
  @Override
  public void configure(final AnyMap configuration) throws ProcessingException {
    _config = configuration;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String[] process(final Blackboard blackboard, final String[] recordIds) throws ProcessingException {
    final ParameterAccessor paramAccessor = new ParameterAccessor(blackboard, _config);
    final ResultCollector resultCollector =
      new ResultCollector(paramAccessor, _log, ProcessingConstants.DROP_ON_ERROR_DEFAULT);
    for (final String id : recordIds) {
      try {
        paramAccessor.setCurrentRecord(id);
        final String pathAttributeName = paramAccessor.getRequiredParameter(PROPERTY_PATH_ATTRIBUTE);
        final String contentAttachmentName = paramAccessor.getRequiredParameter(PROPERTY_CONTENT_ATTACHMENT);
        final String path = blackboard.getMetadata(id).getStringValue(pathAttributeName);
        final File attachmentFile = new File(path);
        blackboard.setAttachmentFromFile(id, contentAttachmentName, attachmentFile);
        resultCollector.addResult(id);
      } catch (final Exception e) {
        resultCollector.addFailedResult(id, new ProcessingException("Error in FileReaderPipelet processing Id "
          + id, e));
      }
    }
    return resultCollector.getResultIds();
  }
}
