/*********************************************************************************************************************
 * Copyright (c) 2008, 2012 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
**********************************************************************************************************************/
package org.eclipse.smila.processing.test;

import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.http.server.json.JsonRequestHandler;
import org.eclipse.smila.processing.httphandler.PipeletHandler;
import org.eclipse.smila.test.DeclarativeServiceTestCase;
import org.eclipse.smila.utils.http.NotFoundHTTPResult;

/** unit tests for {@link PipeletHandler}. */
public class TestPipeletHandler extends DeclarativeServiceTestCase {

  private JsonRequestHandler _handler;

  @Override
  protected void setUp() throws Exception {
    super.setUp();
    _handler = getService(JsonRequestHandler.class, "(uriPattern=/pipelets/\\([^/]+\\)/?$)");
  }

  /** test if correct handler class was found. */
  public void testHandlerType() throws Exception {
    assertTrue(_handler instanceof PipeletHandler);
  }

  /** test getting a pipelet description with parameters section. */
  public void testPipeletWithParameters() throws Exception {
    final String pipeletClass = "org.eclipse.smila.processing.test.Test1Pipelet";
    final AnyMap pipelet = (AnyMap) _handler.process("GET", "/smila/pipelets/" + pipeletClass, null);
    assertNotNull(pipelet);
    assertEquals(pipeletClass, pipelet.getStringValue("class"));
    assertTrue(pipelet.containsKey("description"));
    assertTrue(pipelet.get("description").isString());
    assertTrue(pipelet.containsKey("parameters"));
    assertTrue(pipelet.get("parameters").isSeq());
    assertEquals(2, pipelet.getSeq("parameters").size());
    assertFalse(pipelet.containsKey("errors"));
  }

  /** test getting a pipelet description without parameters section. */
  public void testPipeletWithoutParameters() throws Exception {
    final String pipeletClass = "org.eclipse.smila.processing.test.Test2Pipelet";
    final AnyMap pipelet = (AnyMap) _handler.process("GET", "/smila/pipelets/" + pipeletClass, null);
    assertNotNull(pipelet);
    assertEquals(pipeletClass, pipelet.getStringValue("class"));
    assertTrue(pipelet.containsKey("description"));
    assertTrue(pipelet.get("description").isString());
    assertFalse(pipelet.containsKey("parameters"));
    assertFalse(pipelet.containsKey("errors"));
  }

  /** test getting a pipelet description with empty parameters section. */
  public void testPipeletWithEmptyParameters() throws Exception {
    final String pipeletClass = "org.eclipse.smila.processing.test.Test3Pipelet";
    final AnyMap pipelet = (AnyMap) _handler.process("GET", "/smila/pipelets/" + pipeletClass, null);
    assertNotNull(pipelet);
    assertEquals(pipeletClass, pipelet.getStringValue("class"));
    assertTrue(pipelet.containsKey("description"));
    assertTrue(pipelet.get("description").isString());
    assertTrue(pipelet.containsKey("parameters"));
    assertTrue(pipelet.get("parameters").isSeq());
    assertTrue(pipelet.getSeq("parameters").isEmpty());
    assertFalse(pipelet.containsKey("errors"));
  }

  /** test getting an undefined pipelet. */
  public void testUndefinedPipelet() throws Exception {
    final String pipeletClass = "org.eclipse.smila.processing.test.NoSuchPipelet";
    try {
      _handler.process("GET", "/smila/pipelets/" + pipeletClass, null);
      fail("should not work!");
    } catch (final Exception ex) {
      assertTrue(ex instanceof NotFoundHTTPResult);
    }
  }

  /** test getting a pipelet description without parameters section. */
  public void testPipeletWillNotBeFound() throws Exception {
    final String pipeletClass = "org.eclipse.smila.processing.test.WillNotBeFoundPipelet";
    final AnyMap pipelet = (AnyMap) _handler.process("GET", "/smila/pipelets/" + pipeletClass, null);
    assertNotNull(pipelet);
    assertEquals(pipeletClass, pipelet.getStringValue("class"));
    assertTrue(pipelet.containsKey("description"));
    assertTrue(pipelet.get("description").isString());
    assertFalse(pipelet.containsKey("parameters"));
    assertTrue(pipelet.containsKey("errors"));
    assertTrue(pipelet.get("errors").isSeq());
    assertEquals(1, pipelet.getSeq("errors").size());
  }

  /** test getting a pipelet description without parameters section. */
  public void testInvalidClassAndParameterPipelet() throws Exception {
    final String pipeletClass = "org.eclipse.smila.processing.test.InvalidClassAndParametersPipelet";
    final AnyMap pipelet = (AnyMap) _handler.process("GET", "/smila/pipelets/" + pipeletClass, null);
    assertNotNull(pipelet);
    assertEquals(pipeletClass, pipelet.getStringValue("class"));
    assertTrue(pipelet.containsKey("description"));
    assertTrue(pipelet.get("description").isString());
    assertTrue(pipelet.containsKey("parameters"));
    assertTrue(pipelet.containsKey("errors"));
    assertTrue(pipelet.get("errors").isSeq());
    assertEquals(2, pipelet.getSeq("errors").size());
  }

  /** test getting a pipelet description without parameters section. */
  public void testInvalidParam1Pipelet() throws Exception {
    final String pipeletClass = "org.eclipse.smila.processing.test.InvalidParam1Pipelet";
    final AnyMap pipelet = (AnyMap) _handler.process("GET", "/smila/pipelets/" + pipeletClass, null);
    assertNotNull(pipelet);
    assertEquals(pipeletClass, pipelet.getStringValue("class"));
    assertTrue(pipelet.containsKey("description"));
    assertTrue(pipelet.get("description").isString());
    assertTrue(pipelet.containsKey("parameters"));
    assertTrue(pipelet.containsKey("errors"));
    assertTrue(pipelet.get("errors").isSeq());
    assertEquals(1, pipelet.getSeq("errors").size());
  }

  /** test getting a pipelet description without parameters section. */
  public void testInvalidParam2Pipelet() throws Exception {
    final String pipeletClass = "org.eclipse.smila.processing.test.InvalidParam2Pipelet";
    final AnyMap pipelet = (AnyMap) _handler.process("GET", "/smila/pipelets/" + pipeletClass, null);
    assertNotNull(pipelet);
    assertEquals(pipeletClass, pipelet.getStringValue("class"));
    assertTrue(pipelet.containsKey("description"));
    assertTrue(pipelet.get("description").isString());
    assertTrue(pipelet.containsKey("parameters"));
    assertTrue(pipelet.containsKey("errors"));
    assertTrue(pipelet.get("errors").isSeq());
    assertEquals(1, pipelet.getSeq("errors").size());
  }

}
