/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Schank (Attensity Europe GmbH) - implementation
 *******************************************************************************/
package org.eclipse.smila.processing.worker.test;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.processing.Pipelet;
import org.eclipse.smila.processing.ProcessingException;

public class BpelWorkerTestPipelet2 implements Pipelet {

  public static final String ATTRIBUTE_RECORD_COUNT = "recordCount";

  public static final String SECOND_ATTRIBUTE = "secondCount";

  private final Log _log = LogFactory.getLog(getClass());

  @Override
  public String[] process(final Blackboard blackboard, final String[] recordIds) throws ProcessingException {
    final int parallelRecordCount = recordIds.length;
    try {
      for (final String id : recordIds) {
        if (blackboard.getMetadata(id).containsKey(ATTRIBUTE_RECORD_COUNT)) {
          blackboard.getMetadata(id).put(SECOND_ATTRIBUTE, blackboard.getMetadata(id).get(ATTRIBUTE_RECORD_COUNT));
        }
        blackboard.getMetadata(id).add(SECOND_ATTRIBUTE, DataFactory.DEFAULT.createLongValue(parallelRecordCount));
        if (_log.isDebugEnabled()) {
          _log.debug("record: " + blackboard.getMetadata(id).toString());
        }
      }
    } catch (final Exception ex) {
      throw new ProcessingException(ex);
    }
    return recordIds;
  }

  @Override
  public void configure(final AnyMap configuration) throws ProcessingException {
    ; // nothing to do
  }

}
