/**********************************************************************************************************************
 * Copyright (c) 2008, 2014 Empolis Information Management GmbH and brox IT Solutions GmbH. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors: Andreas Weber (Empolis Information Management GmbH) - initial implementation
 **********************************************************************************************************************/
package org.eclipse.smila.scripting.test;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotSame;

import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.scripting.ScriptingEngine;
import org.eclipse.smila.utils.service.ServiceUtils;
import org.junit.Before;
import org.junit.Test;

/**
 * Test execution of OSGI Services within scripts.
 */
public class TestCallingServicesInScripts {

  private ScriptingEngine _scriptEngine;

  @Before
  public void setup() throws Exception {
    _scriptEngine = ServiceUtils.getService(ScriptingEngine.class);
  }

  @Test
  /** simple test with ObjectstoreService. */
  public void test() throws Exception {
    final Record inputRecord = DataFactory.DEFAULT.createRecord("id");
    inputRecord.getMetadata().put("store", "teststore");

    _scriptEngine.callScript("testServices.ensureStore", inputRecord);

    Record resultRecord = _scriptEngine.callScript("testServices.putObject", inputRecord);
    assertEquals("hello", resultRecord.getMetadata().getStringValue("put"));

    resultRecord = _scriptEngine.callScript("testServices.getObject", inputRecord);
    assertEquals("hello", resultRecord.getMetadata().getStringValue("get"));

    _scriptEngine.callScript("testServices.removeStore", inputRecord);
  }

  @Test
  /** test calling service by using input record. */
  public void testUsingInputRecord() throws Exception {
    final Record inputRecord = DataFactory.DEFAULT.createRecord("id");
    inputRecord.getMetadata().put("testAtt", "I am a job run");
    final Record resultRecord = _scriptEngine.callScript("testServices.storeAndGetJobRun", inputRecord);
    assertEquals(inputRecord.getMetadata(), resultRecord.getMetadata());
    assertNotSame(inputRecord, resultRecord);
  }
}
