/**********************************************************************************************************************
 * Copyright (c) 2008, 2014 Empolis Information Management GmbH and brox IT Solutions GmbH. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher (Empolis Information Management GmbH) - initial implementation
 **********************************************************************************************************************/
package org.eclipse.smila.scripting.test;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import org.eclipse.smila.scripting.ScriptingEngine;
import org.eclipse.smila.scripting.internal.JavascriptEngine;
import org.eclipse.smila.utils.service.ServiceUtils;
import org.junit.Test;

public class TestEngineService {

  @Test
  public void testServiceRegistered() throws Exception {
    final ScriptingEngine service = ServiceUtils.getService(ScriptingEngine.class);
    assertNotNull(service);
    assertTrue(service instanceof JavascriptEngine);
  }

}
