/**********************************************************************************************************************
 * Copyright (c) 2008, 2014 Empolis Information Management GmbH and brox IT Solutions GmbH. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors: Juergen Schumacher (Empolis Information Management GmbH) - initial implementation
 **********************************************************************************************************************/
package org.eclipse.smila.scripting.test;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.scripting.ScriptingEngine;
import org.eclipse.smila.utils.service.ServiceUtils;
import org.junit.Before;
import org.junit.Test;

public class TestScriptCatalog {
  private ScriptingEngine _engine;

  @Before
  public void setup() throws Exception {
    _engine = ServiceUtils.getService(ScriptingEngine.class);
  }

  @Test
  public void testReadCatalogs() throws Exception {
    final AnySeq scripts = _engine.listScripts();
    assertTrue(scripts.size() >= 3);
    int foundFunctions = 0;
    // check if entries from oneScriptCatalog.js and twoScriptCatalog.js appear in correct order.
    // later tests may add more entries.
    for (final Any script : scripts) {
      assertTrue(script.isMap());
      final String name = script.asMap().getStringValue("name");
      assertNotNull(name);
      if ("one.test".equals(name)) {
        assertEquals(name + " found too early", 0, foundFunctions++);
      }
      if ("two.test.1".equals(name)) {
        assertEquals(name + " found too early", 1, foundFunctions++);
        // check if "require" works in script catalogs, too
        assertEquals("SMILA Unit Tests", script.asMap().getStringValue("provider"));
      }
      if ("two.test.2".equals(name)) {
        assertEquals(name + " found too early", 2, foundFunctions++);
        // check if "require" works in script catalogs, too
        assertEquals("SMILA Unit Tests", script.asMap().getStringValue("provider"));
      }

    }
  }
}
