/**********************************************************************************************************************
 * Copyright (c) 2008, 2014 Empolis Information Management GmbH and brox IT Solutions GmbH. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors: Juergen Schumacher (Empolis Information Management GmbH) - initial implementation
 **********************************************************************************************************************/
package org.eclipse.smila.scripting.test;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.fail;

import java.util.Vector;

import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.scripting.ScriptingEngine;
import org.eclipse.smila.utils.service.ServiceUtils;
import org.junit.Before;
import org.junit.Test;

public class TestScriptExecutionParallel {

  private ScriptingEngine _engine;

  private static boolean canRun = true;

  @Before
  public void setup() throws Exception {
    _engine = ServiceUtils.getService(ScriptingEngine.class);
  }

  public class Executor implements Runnable {

    public Executor(final String indexName) {
    }

    @Override
    public void run() {

      final AnyMap input = DataFactory.DEFAULT.createAnyMap();

      for (int i = 0; i < 100; i++) {
        try {
          final AnyMap result = _engine.callScript("testExecutionHandler.scopeTest", input);
          assertEquals("4.0", result.getStringValue("count1"));
          assertEquals("12.0", result.getStringValue("count2"));
          if (!canRun) {
            break;
          }
        } catch (final Exception e) {
          e.printStackTrace();
          fail();
        }
      }
    }
  }

  private void spawnExecutors(final Vector<Thread> threads) throws Exception {

    final int count = threads.capacity();

    final Vector<Executor> ecutors = new Vector<Executor>(count);
    for (int i = 0; i < count / 2; i++) {
      ecutors.add(new Executor("load01"));
    }
    for (int i = 0; i < count / 2; i++) {
      ecutors.add(new Executor("load02"));
    }

    for (int i = 0; i < count; i++) {
      threads.add(new Thread(ecutors.elementAt(i)));
    }

    for (int i = 0; i < count; i++) {
      threads.elementAt(i).start();
    }
  }

  private void joinN(final Vector<Thread> threads) throws Exception {

    final int count = threads.capacity();
    for (int i = 0; i < count; i++) {
      threads.elementAt(i).join();
    }
  }

  @Test
  public void testBasicParallel() throws Exception {

    final int ecount = 4;

    final Vector<Thread> ethreads = new Vector<Thread>(ecount);

    spawnExecutors(ethreads);

    // canRun = false;
    joinN(ethreads);
  }
}
