/**********************************************************************************************************************
 * Copyright (c) 2008, 2014 Empolis Information Management GmbH and brox IT Solutions GmbH. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Marco Strack (Empolis Information Management GmbH) - initial implementation
 **********************************************************************************************************************/
package org.eclipse.smila.scripting.test.httphandler;

import static org.junit.Assert.assertTrue;

import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.http.client.impl.DefaultRestClient;
import org.junit.Test;

/**
 * Test cases for the {@link BucketHandler} and {@link BucketsHandler}.
 */
public class TestListScripts {

  public static final String BASE_URL = "http://localhost:8080/smila";

  private static final DefaultRestClient REST_CLIENT = new DefaultRestClient(BASE_URL);

  /**
   * test basic list.
   * 
   * @throws Exception
   */
  @Test
  public void testBasicList() throws Exception {
    final Any jsonResult = REST_CLIENT.get("/script");
    assertTrue(jsonResult.asMap().containsKey("scripts"));
    final AnySeq resultSeq = jsonResult.asMap().getSeq("scripts");
    assertTrue(resultSeq.size() > 0);
    for (final Any singleEntry : resultSeq) {
      assertTrue(singleEntry.asMap().containsKey("name"));
      assertTrue(singleEntry.asMap().containsKey("description"));
      assertTrue(singleEntry.asMap().containsKey("url"));
    }
  }
}
