/**********************************************************************************************************************
 * Copyright (c) 2008, 2014 Empolis Information Management GmbH and brox IT Solutions GmbH. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Marco Strack (Empolis Information Management GmbH) - initial implementation
 **********************************************************************************************************************/
package org.eclipse.smila.scripting.test.httphandler;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.http.client.RestException;
import org.eclipse.smila.http.client.impl.DefaultRestClient;
import org.junit.Before;
import org.junit.Test;

/**
 * Test cases for the {@link BucketHandler} and {@link BucketsHandler}.
 */
public class TestScriptsExecutionHTTP {

  public static final String BASE_URL = "http://localhost:8080/smila";

  private static final DefaultRestClient REST_CLIENT = new DefaultRestClient(BASE_URL);

  /** {@inheritDoc} */
  @Before
  public void setUp() throws Exception {
  }

  /**
   * test basic execution
   * 
   * @throws Exception
   */
  @Test
  public void testBasicExecution() throws Exception {
    final AnyMap parameters = DataFactory.DEFAULT.createAnyMap();
    parameters.put("testKey", "Dies ist ein Überfall");

    final Any jsonResult = REST_CLIENT.post("/script/testExecutionHandler.setAttributes", parameters);
    final AnyMap result = jsonResult.asMap();
    // just some basic tests
    assertTrue(result.containsKey("testKey"));
    assertTrue(result.containsKey("boolean"));
    assertTrue(result.containsKey("integer"));
    assertTrue(result.containsKey("string"));
    assertEquals("Dies ist ein Überfall", result.getStringValue("testKey"));
    assertEquals(true, result.getBooleanValue("boolean"));
    assertEquals(42, result.getLongValue("integer").intValue());
    assertEquals("a string", result.getStringValue("string"));
  }

  /**
   * test errors
   * 
   * @throws Exception
   */
  @Test
  public void testErrors() throws Exception {

    // script not there
    final AnyMap parameters = DataFactory.DEFAULT.createAnyMap();
    parameters.put("testKey", "Dies ist ein Überfall");

    try {
      REST_CLIENT.post("/script/testExecxutionHandler.setAttributes", parameters);
      fail("should not work");
    } catch (final RestException e) {
      // e.printStackTrace();
      assertEquals(404, e.getResponseCode());
    }

    // function not there
    try {
      REST_CLIENT.post("/script/testExecutionHandler.setxAttributes", parameters);
      fail("should not work");
    } catch (final RestException e) {
      // e.printStackTrace();
      assertEquals(404, e.getResponseCode());
    }

    // function broken
    try {
      REST_CLIENT.post("/script/testExecutionHandler.brokenFunction", parameters);
      fail("should not work");
    } catch (final RestException e) {
      // e.printStackTrace();
      assertEquals(400, e.getResponseCode());
    }
  }
}
