/**********************************************************************************************************************
 * Copyright (c) 2008, 2014 Empolis Information Management GmbH and brox IT Solutions GmbH. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 **********************************************************************************************************************/
package org.eclipse.smila.scripting.test.worker;

import static org.eclipse.smila.jobmanager.definitions.JobManagerConstants.DATA_JOB_NO_OF_FAILED_TASKS_NOT_RETRIED;
import static org.eclipse.smila.jobmanager.definitions.JobManagerConstants.DATA_JOB_NO_OF_FAILED_TASKS_RETRIED;
import static org.eclipse.smila.jobmanager.definitions.JobManagerConstants.DATA_JOB_NO_OF_RETRIED_TASKS_WORKER;
import static org.eclipse.smila.jobmanager.definitions.JobManagerConstants.DATA_JOB_NO_OF_SUCCESSFUL_TASKS;
import static org.eclipse.smila.jobmanager.definitions.JobManagerConstants.DATA_JOB_STATE;
import static org.junit.Assert.assertEquals;

import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.junit.Test;

public class TestWorkerErrors extends ScriptProcessorWorkerTestBase {

  @Test
  public void testPrepareError() throws Exception {
    final String jobName = "testPrepareError";
    final AnyMap parameters = DataFactory.DEFAULT.createAnyMap();
    parameters.put("initializeFunction", "throwException");
    final String jobRunId = startJobWithoutOutput(jobName, "testWorkerErrors", parameters);
    _bulkbuilder.addRecord(jobName, record(jobName));
    _jobRunEngine.finishJob(jobName, jobRunId);
    waitForJobRunCompleted(jobName, jobRunId);
    final AnyMap jobRunData = _jobRunData.getJobRunData(jobName, jobRunId);
    assertEquals("FAILED", jobRunData.getStringValue(DATA_JOB_STATE));
    final AnyMap scriptWorkerCounter = getScriptWorkerCounter(jobName, jobRunId);
    assertEquals(1, scriptWorkerCounter.getLongValue(DATA_JOB_NO_OF_FAILED_TASKS_NOT_RETRIED).intValue());
  }

  @Test
  public void testPrepareRecoverableError() throws Exception {
    final String jobName = "testPrepareRecoverableError";
    final AnyMap parameters = DataFactory.DEFAULT.createAnyMap();
    parameters.put("initializeFunction", "throwRecoverableException");
    final String jobRunId = startJobWithoutOutput(jobName, "testWorkerErrors", parameters);
    _bulkbuilder.addRecord(jobName, record(jobName));
    _jobRunEngine.finishJob(jobName, jobRunId);
    waitForJobRunCompleted(jobName, jobRunId);
    final AnyMap jobRunData = _jobRunData.getJobRunData(jobName, jobRunId);
    assertEquals("FAILED", jobRunData.getStringValue(DATA_JOB_STATE));
    final AnyMap scriptWorkerCounter = getScriptWorkerCounter(jobName, jobRunId);
    assertEquals(10, scriptWorkerCounter.getLongValue(DATA_JOB_NO_OF_RETRIED_TASKS_WORKER).intValue());
    assertEquals(1, scriptWorkerCounter.getLongValue(DATA_JOB_NO_OF_FAILED_TASKS_RETRIED).intValue());
  }

  @Test
  public void testPrepareRuntimeError() throws Exception {
    final String jobName = "testPrepareRuntimeError";
    final AnyMap parameters = DataFactory.DEFAULT.createAnyMap();
    parameters.put("initializeFunction", "throwRuntimeException");
    final String jobRunId = startJobWithoutOutput(jobName, "testWorkerErrors", parameters);
    _bulkbuilder.addRecord(jobName, record(jobName));
    _jobRunEngine.finishJob(jobName, jobRunId);
    waitForJobRunCompleted(jobName, jobRunId);
    final AnyMap jobRunData = _jobRunData.getJobRunData(jobName, jobRunId);
    assertEquals("FAILED", jobRunData.getStringValue(DATA_JOB_STATE));
    final AnyMap scriptWorkerCounter = getScriptWorkerCounter(jobName, jobRunId);
    assertEquals(1, scriptWorkerCounter.getLongValue(DATA_JOB_NO_OF_FAILED_TASKS_NOT_RETRIED).intValue());
  }

  @Test
  public void testProcessError() throws Exception {
    final String jobName = "testProcessError";
    final AnyMap parameters = DataFactory.DEFAULT.createAnyMap();
    final String jobRunId = startJobWithOutput(jobName, "testWorkerErrors", parameters);
    for (int i = 0; i < 3; i++) {
      final Record record = record(jobName + i);
      if (i == 1) {
        record.getMetadata().put("error", "error");
      }
      _bulkbuilder.addRecord(jobName, record);
    }
    _jobRunEngine.finishJob(jobName, jobRunId);
    waitForJobRunCompleted(jobName, jobRunId);
    final AnyMap jobRunData = _jobRunData.getJobRunData(jobName, jobRunId);
    assertEquals("SUCCEEDED", jobRunData.getStringValue(DATA_JOB_STATE));
    final AnyMap scriptWorkerCounter = getScriptWorkerCounter(jobName, jobRunId);
    assertEquals(1, scriptWorkerCounter.getLongValue(DATA_JOB_NO_OF_SUCCESSFUL_TASKS).intValue());
    assertEquals(1, scriptWorkerCounter.getLongValue("warnCount").intValue());
    assertEquals(2, scriptWorkerCounter.getLongValue("output.output.recordCount").intValue());
  }

  @Test
  public void testProcessRecoverableError() throws Exception {
    final String jobName = "testProcessRecoverableError";
    final AnyMap parameters = DataFactory.DEFAULT.createAnyMap();
    final String jobRunId = startJobWithOutput(jobName, "testWorkerErrors", parameters);
    for (int i = 0; i < 3; i++) {
      final Record record = record(jobName + i);
      if (i == 1) {
        record.getMetadata().put("error", "recoverable");
      }
      _bulkbuilder.addRecord(jobName, record);
    }
    _jobRunEngine.finishJob(jobName, jobRunId);
    waitForJobRunCompleted(jobName, jobRunId);
    final AnyMap jobRunData = _jobRunData.getJobRunData(jobName, jobRunId);
    assertEquals("FAILED", jobRunData.getStringValue(DATA_JOB_STATE));
    final AnyMap scriptWorkerCounter = getScriptWorkerCounter(jobName, jobRunId);
    assertEquals(10, scriptWorkerCounter.getLongValue(DATA_JOB_NO_OF_RETRIED_TASKS_WORKER).intValue());
    assertEquals(1, scriptWorkerCounter.getLongValue(DATA_JOB_NO_OF_FAILED_TASKS_RETRIED).intValue());
  }

  @Test
  public void testProcessRuntimeError() throws Exception {
    final String jobName = "testProcessRuntimeError";
    final AnyMap parameters = DataFactory.DEFAULT.createAnyMap();
    final String jobRunId = startJobWithOutput(jobName, "testWorkerErrors", parameters);
    for (int i = 0; i < 3; i++) {
      final Record record = record(jobName + i);
      if (i == 1) {
        record.getMetadata().put("error", "runtime");
      }
      _bulkbuilder.addRecord(jobName, record);
    }
    _jobRunEngine.finishJob(jobName, jobRunId);
    waitForJobRunCompleted(jobName, jobRunId);
    final AnyMap jobRunData = _jobRunData.getJobRunData(jobName, jobRunId);
    assertEquals("SUCCEEDED", jobRunData.getStringValue(DATA_JOB_STATE));
    final AnyMap scriptWorkerCounter = getScriptWorkerCounter(jobName, jobRunId);
    assertEquals(1, scriptWorkerCounter.getLongValue(DATA_JOB_NO_OF_SUCCESSFUL_TASKS).intValue());
    assertEquals(1, scriptWorkerCounter.getLongValue("warnCount").intValue());
    assertEquals(2, scriptWorkerCounter.getLongValue("output.output.recordCount").intValue());
  }

  @Test
  public void testPipeletError() throws Exception {
    final String jobName = "testPipeletError";
    final AnyMap parameters = DataFactory.DEFAULT.createAnyMap();
    parameters.put("function", "processPipelet");
    final String jobRunId = startJobWithOutput(jobName, "testWorkerErrors", parameters);
    for (int i = 0; i < 3; i++) {
      final Record record = record(jobName + i);
      if (i == 1) {
        record.getMetadata().put("json", "this is not json");
      } else {
        record.getMetadata().put("json", "{ \"index\": " + i + " }");
      }
      _bulkbuilder.addRecord(jobName, record);
    }
    _jobRunEngine.finishJob(jobName, jobRunId);
    waitForJobRunCompleted(jobName, jobRunId);
    final AnyMap jobRunData = _jobRunData.getJobRunData(jobName, jobRunId);
    assertEquals("SUCCEEDED", jobRunData.getStringValue(DATA_JOB_STATE));
    final AnyMap scriptWorkerCounter = getScriptWorkerCounter(jobName, jobRunId);
    assertEquals(1, scriptWorkerCounter.getLongValue(DATA_JOB_NO_OF_SUCCESSFUL_TASKS).intValue());
    assertEquals(1, scriptWorkerCounter.getLongValue("warnCount").intValue());
    assertEquals(2, scriptWorkerCounter.getLongValue("output.output.recordCount").intValue());
  }

}
