/**********************************************************************************************************************
 * Copyright (c) 2008, 2014 Empolis Information Management GmbH and brox IT Solutions GmbH. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 **********************************************************************************************************************/
package org.eclipse.smila.scripting.test.worker;

import static org.junit.Assert.assertEquals;

import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.junit.Test;

public class TestWorkerLog extends ScriptProcessorWorkerTestBase {

  @Test
  public void testLogInfos() throws Exception {
    final String jobName = "testLogInfos";
    final AnyMap parameters = DataFactory.DEFAULT.createAnyMap();
    final String jobRunId = startJobWithoutOutput(jobName, "testWorkerLog", parameters);
    final int expectedInfoCount = 2;
    _bulkbuilder.addRecord(jobName, record(jobName, expectedInfoCount, 0, 0));
    _jobRunEngine.finishJob(jobName, jobRunId);
    waitForJobRunCompleted(jobName, jobRunId);
  }

  @Test
  public void testLogWarnings() throws Exception {
    final String jobName = "testLogWarnings";
    final AnyMap parameters = DataFactory.DEFAULT.createAnyMap();
    final String jobRunId = startJobWithoutOutput(jobName, "testWorkerLog", parameters);
    final int expectedWarnCount = 3;
    _bulkbuilder.addRecord(jobName, record(jobName, 0, expectedWarnCount, 0));
    _jobRunEngine.finishJob(jobName, jobRunId);
    waitForJobRunCompleted(jobName, jobRunId);
    final AnyMap scriptWorkerCounter = getScriptWorkerCounter(jobName, jobRunId);
    assertEquals(expectedWarnCount, scriptWorkerCounter.getLongValue("warnCount").intValue());
  }

  @Test
  public void testLogErrors() throws Exception {
    final String jobName = "testLogError";
    final AnyMap parameters = DataFactory.DEFAULT.createAnyMap();
    final String jobRunId = startJobWithoutOutput(jobName, "testWorkerLog", parameters);
    final int expectedErrorCount = 1;
    _bulkbuilder.addRecord(jobName, record(jobName, 0, 0, expectedErrorCount));
    _jobRunEngine.finishJob(jobName, jobRunId);
    waitForJobRunCompleted(jobName, jobRunId);
  }

  @Test
  public void testLogAllLevels() throws Exception {
    final String jobName = "testLogAllLevels";
    final AnyMap parameters = DataFactory.DEFAULT.createAnyMap();
    final String jobRunId = startJobWithoutOutput(jobName, "testWorkerLog", parameters);
    final int expectedInfoCount = 3;
    final int expectedWarnCount = 2;
    final int expectedErrorCount = 1;
    _bulkbuilder.addRecord(jobName, record(jobName, expectedInfoCount, expectedWarnCount, expectedErrorCount));
    _jobRunEngine.finishJob(jobName, jobRunId);
    waitForJobRunCompleted(jobName, jobRunId);
    final AnyMap scriptWorkerCounter = getScriptWorkerCounter(jobName, jobRunId);
    assertEquals(expectedWarnCount, scriptWorkerCounter.getLongValue("warnCount").intValue());
  }

  protected Record record(final String recordId, final int infoCount, final int warnCount, final int errorCount) {
    final Record record = record(recordId);
    record.getMetadata().put("info", infoCount);
    record.getMetadata().put("warn", warnCount);
    record.getMetadata().put("error", errorCount);
    return record;
  }
}
