function getAttachment(record) {
  var attachment = record.$attachments.attachment;
  record.size = attachment.size();
  record.typeOfBytes = typeof (attachment.getAsBytes());
  record.typeOfStream = typeof (attachment.getAsStream());
  return record;
}

function copyAttachment(record) {
  var name = record.name;
  var newName = record.newName;
  var attachment = record.$attachments[name];
  record.size = attachment.size();
  record.$attachments[newName] = attachment;
  return record;
}

function setAttachmentFromString(record) {
  var name = record.name;
  var content = "Attachment: " + record.content;
  record.$attachments[name] = content;
  return record;
}

function setAttachmentFromStream(record) {
  importPackage(java.io);
  var filename = record.filename;
  var stream = new FileInputStream(filename);
  var name = record.name;
  record.$attachments[name] = stream;
  return record;
}

function setAttachmentFromInvalidType(record) {
  record.$attachments.metadata = record;
  return record;
}

function deleteAttachment(record) {
  delete record.$attachments[record.name];
  return record;
}

