var setValuePipelet = pipelets.create("org.eclipse.smila.processing.pipelets.SetValuePipelet", {
  "outputAttribute" : "testAtt",
  "value" : "testValue"
});

function testPipeletCreatedOutside(record) {
  setValuePipelet.process(record);
  return record;
}

/* without function return value. */
function testScriptReturnsNoResult(record) {
  setValuePipelet.process(record);
}

/* creating pipelet in function. */
function testPipeletCreatedInFunction(record) {
  var pipelet = "org.eclipse.smila.processing.pipelets.SetValuePipelet"
  var config = {
    "outputAttribute" : "testAtt3",
    "value" : "testValue3a"
  }
  var setValuePipelet = pipelets.create(pipelet, config);
  setValuePipelet.process(record);
  return record
}

/* creating pipelet in function, return result from pipelet */
function testPipeletCreatedInFunctionReturningResult(record) {
  var pipelet = "org.eclipse.smila.processing.pipelets.SetValuePipelet"
  var config = {
    "outputAttribute" : "testAtt3",
    "value" : "testValue3b"
  }
  var setValuePipelet = pipelets.create(pipelet, config);
  var result = setValuePipelet.process(record);
  return result[0]
}

/* use multiple pipelets, one uses the result of the other */
function testMultiplePipelets(record) {
  var pipelet1 = "org.eclipse.smila.processing.pipelets.SetValuePipelet"
  var config1 = {
    "outputAttribute" : "testAtt4-1",
    "value" : "testValue4-1"
  };
  var setValuePipelet1 = pipelets.create(pipelet1, config1);

  var results = setValuePipelet1.process(record);
  var result = results[0]

  var pipelet2 = "org.eclipse.smila.processing.pipelets.SetValuePipelet"
  var config2 = {
    "outputAttribute" : "testAtt4-2",
    "value" : "testValue4-2"
  }
  var setValuePipelet2 = pipelets.create(pipelet2, config2);

  setValuePipelet2.process(result);
  return result;
}

/* use map as input record */
function testMapAsInput(record) {
  var map = {
    "_recordid" : "id5"
  }
  var result = setValuePipelet.process(map);
  return result[0];
}

/* pipelet creates multiple output records */
function testPipeletCreatesRecords(record) {
  var pipelet = "org.eclipse.smila.processing.pipelets.DocumentSplitterPipelet";
  var config = {
    "partsAttribute" : "parts"
  };
  var splitPipelet = pipelets.create(pipelet, config);
  var result = splitPipelet.process(record);
  for ( var rec in result) {    
    result[rec].loop = "for";    
  }
  return result;
}

/* first pipelet creates multiple output records used by second pipelet as input */
function testPipeletCreatesRecordsUsedAsPipeletInput(record) {
  var config = {
    "partsAttribute" : "parts"
  };
  var splitPipelet = pipelets.create("org.eclipse.smila.processing.pipelets.DocumentSplitterPipelet", config);  
  var result = splitPipelet.process(record);  
  setValuePipelet.process(result);
  return result;
}

/* use multiple maps as input records */
function testMultipleMapsAsInput(record) {
  var rec1 = {
    "_recordid" : "id8-1",
    "page" : 17
  }
  var rec2 = {
    "_recordid" : "id8-2",
    "page" : 18
  }
  var maps = [ rec1, rec2 ]
  var result = setValuePipelet.process(maps);
  return result;
}

/* use input record as config for a pipelet */
function testInputRecordAsConfig(record) {
  var setValuePipelet = pipelets.create("org.eclipse.smila.processing.pipelets.SetValuePipelet", record);
  setValuePipelet.process(record);
  return record;
}

/* use pipelet result as config for another pipelet */
function testPipeletResultAsConfig(record) {
  var config1 = {
    "outputAttribute" : "outputAttribute",
    "value" : "testConfig2"
  }
  var config2 = {
    "outputAttribute" : "valuesToAdd",
    "value" : [ "v1", "v2" ]
  }
  /* the SetValuePipelet's create the config for the following AddValuesPipelet. */
  var setValuePipelet1 = pipelets.create("org.eclipse.smila.processing.pipelets.SetValuePipelet", config1);
  var setValuePipelet2 = pipelets.create("org.eclipse.smila.processing.pipelets.SetValuePipelet", config2);
  setValuePipelet1.process(record);
  setValuePipelet2.process(record);

  var addValuesPipelet = pipelets.create("org.eclipse.smila.processing.pipelets.AddValuesPipelet", record);
  addValuesPipelet.process(record);
  return record
}

function testPipeletError(record) {
  var errorPipelet = pipelets.create("org.eclipse.smila.processing.bpel.pipelet.ErrorPipelet", null);
  errorPipelet.process(record);
  return record;
}
