/* functions used in tests. */

function ensureStore(record) {
  var objectstore = services.find("org.eclipse.smila.objectstore.ObjectStoreService");
  var store = record.store;
  objectstore.ensureStore(store);
  return record;
}

function putObject(record) {
  var objectstore = services.find("org.eclipse.smila.objectstore.ObjectStoreService");
  var store = record.store;
  record.put = "hello";
  var bytes = stringToBytes(record.put);
  objectstore.putObject(store, "testObjectId", bytes);
  return record;
}

function getObject(record) {
  var objectstore = services.find("org.eclipse.smila.objectstore.ObjectStoreService");
  var store = record.store;
  var bytes = objectstore.getObject(store, "testObjectId");
  record.get = bytes2String(bytes);
  return record;
}

function removeStore(record) {
  var objectstore = services.find("org.eclipse.smila.objectstore.ObjectStoreService");
  var store = record.store;
  objectstore.removeStore(store);
  return record;
}

function storeAndGetJobRun(record) {
  var jobstore = services.find("org.eclipse.smila.jobmanager.persistence.PermanentStorage");
  jobstore.storeJobRun("jobName", "jobRun", record.$metadata);
  var result = jobstore.getJobRunData("jobName", "jobRun");
  return result;
}

/* helper functions. */

function stringToBytes(str) {
  var javastring = new java.lang.String(str);
  return javastring.getBytes("utf-8");
}

function bytes2String(array) {
  var javastring = new java.lang.String(array, "utf-8");
  return javastring;
}
