var Constants = require("test/testConstants");

var taskParameters;

var objectstore;
var storeName;
var bonWriter;

var prepared = "prepare";

function prepare(parameters) {
  taskParameters = parameters;
  objectstore = services.find("org.eclipse.smila.objectstore.ObjectStoreService");
  bonWriter = new org.eclipse.smila.datamodel.ipc.IpcAnyWriter(true);

  storeName = taskParameters.store;
  objectstore.ensureStore(storeName);
}

function alternativePrepare(parameters) {
  prepare(parameters);
  prepared = "alternativePrepare";
}

function writeRecordToStore(record) {
  var bonObject = bonWriter.writeBinaryObject(record.$metadata);
  objectstore.putObject(storeName, "record/" + record.$id, bonObject);
}

function processRecord(record) {
  if (record.fail) {
    alternativePrepare
    throw record.$id + " must fail.";
  }
  if (record.skip) {
    return null;
  }
  record.processed = true;
  record.prepare = prepared;
  record.processor = Constants.PROVIDER;
  record.taskParameters = taskParameters;

  writeRecordToStore(record);

  return record;
}

function alternativeProcess(record) {
  record.alternativeProcessed = true;
  record.prepare = prepared;
  record.processor = Constants.PROVIDER;
  return record;
}
