/**********************************************************************************************************************
 * Copyright (c) 2008, 2014 Empolis Information Management GmbH and brox IT Solutions GmbH. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher (Empolis Information Management GmbH) - initial implementation
 **********************************************************************************************************************/
package org.eclipse.smila.scripting;

import org.eclipse.smila.utils.MaybeRecoverableException;

/**
 * Exceptions thrown by {@link ScriptingEngine} implementation on errors.
 */
public class ScriptingEngineException extends MaybeRecoverableException {

  private static final long serialVersionUID = 1L;

  /** Creates exception. */
  public ScriptingEngineException(final String message, final boolean recoverable) {
    super(message, recoverable);
  }

  /** Creates exception. */
  public ScriptingEngineException(final String message, final Throwable cause, final boolean recoverable) {
    super(message, cause, recoverable);
  }

  /** Creates exception. */
  public ScriptingEngineException(final String message, final Throwable cause) {
    super(message, cause, isRecoverableCause(cause));
  }

  /** Creates exception. */
  public ScriptingEngineException(final String message) {
    super(message);
  }

  /**
   * @return Check if cause is a {@link MaybeRecoverableException} or if it wraps a {@link MaybeRecoverableException}
   *         and use its recoverable flag.
   */
  public static boolean isRecoverableCause(final Throwable cause) {
    if (cause instanceof MaybeRecoverableException) {
      return ((MaybeRecoverableException) cause).isRecoverable();
    }
    if (cause.getCause() != null) {
      return isRecoverableCause(cause.getCause());
    }
    return false;
  }

}
