/**********************************************************************************************************************
 * Copyright (c) 2008, 2014 Empolis Information Management GmbH and brox IT Solutions GmbH. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors: Juergen Schumacher (Empolis Information Management GmbH) - initial implementation
 **********************************************************************************************************************/
package org.eclipse.smila.scripting.internal;

import org.eclipse.smila.datamodel.AnyMap;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

/**
 * Wraps an AnyMap as a Javascript object.
 *
 */
public class AnyMapWrapper extends ObjectWrapperBase {

  private final AnyMap _map;

  public AnyMapWrapper(final AnyMap map, final Scriptable parentScope) {
    super(parentScope);
    _map = map;
  }

  @Override
  public AnyMap unwrap() {
    return _map;
  }

  @Override
  public String getClassName() {
    return "AnyMapWrapper";
  }

  @Override
  public Object get(final String name, final Scriptable start) {
    return AnyWrapper.wrapAny(_map.get(name), getParentScope());
  }

  @Override
  public Object get(final int index, final Scriptable start) {
    throw Context.reportRuntimeError("Number keys are not allowed for Maps.");
  }

  @Override
  public boolean has(final String name, final Scriptable start) {
    return _map.containsKey(name);
  }

  @Override
  public boolean has(final int index, final Scriptable start) {
    return false;
  }

  @Override
  public void put(final String name, final Scriptable start, final Object value) {
    if (value != null) {
      _map.put(name, AnyWrapper.unwrapAny(value));
    } else { // to allow 'null' as assign value in JS (e.g. record.test = null)
      _map.remove(name);
    }
  }

  @Override
  public void put(final int index, final Scriptable start, final Object value) {
    throw Context.reportRuntimeError("Number keys are not allowed for Maps.");
  }

  @Override
  public void delete(final String name) {
    _map.remove(name);
  }

  @Override
  public void delete(final int index) {
    throw Context.reportRuntimeError("Number keys are not allowed for Maps.");
  }

  @Override
  public Object[] getIds() {
    return _map.keySet().toArray();
  }
}
