/**********************************************************************************************************************
 * Copyright (c) 2008, 2014 Empolis Information Management GmbH and brox IT Solutions GmbH. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors: Juergen Schumacher (Empolis Information Management GmbH) - initial implementation
 **********************************************************************************************************************/
package org.eclipse.smila.scripting.internal;

import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Wrapper;

/**
 * Base class for Javascript wrappers for SMILA objects (Any, Record, ...).
 */
public abstract class ObjectWrapperBase implements Scriptable, Wrapper {

  private Scriptable _parentScope;

  private Scriptable _prototype;

  /** Creates object. */
  public ObjectWrapperBase(final Scriptable parentScope) {
    _parentScope = parentScope;
    _prototype = ScriptableObject.getObjectPrototype(parentScope);
  }

  @Override
  public Scriptable getPrototype() {
    return _prototype;
  }

  @Override
  public void setPrototype(final Scriptable prototype) {
    _prototype = prototype;
  }

  @Override
  public Scriptable getParentScope() {
    return _parentScope;
  }

  @Override
  public void setParentScope(final Scriptable parent) {
    _parentScope = parent;
  }

  @Override
  public Object getDefaultValue(final Class<?> hint) {
    if (hint == ScriptRuntime.BooleanClass) {
      return Boolean.TRUE;
    }
    if (hint == ScriptRuntime.NumberClass) {
      return ScriptRuntime.NaNobj;
    }
    return unwrap().toString();
  }

  @Override
  public boolean hasInstance(final Scriptable instance) {
    return false;
  }

}
