/*******************************************************************************
 * Copyright (c) 2009 empolis GmbH and brox IT Solutions GmbH. All rights reserved. This program and the accompanying
 * materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors: Juergen Schumacher (empolis GmbH) - initial API and implementation
 *******************************************************************************/

package org.eclipse.smila.search.servlet.activator;

import org.eclipse.smila.search.api.SearchService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

/**
 * Activator for search servlet bundle. Purpose is to create a ServiceTracker for {@link SearchService} services.
 *
 * @author jschumacher
 *
 */
public class Activator implements BundleActivator {
  /**
   * bundle name.
   */
  public static final String BUNDLE_NAME = "org.eclipse.smila.search.servlet";

  /** singleton instance. */
  private static Activator s_instance;

  /**
   * Bundle context.
   */
  private BundleContext _bundleContext;

  /**
   * service tracker for SMILA search service.
   */
  private ServiceTracker<SearchService, SearchService> _searchServiceTracker;

  /**
   * Get activator instance.
   *
   * @return the activator instance.
   */
  public static Activator getInstance() {
    return s_instance;
  }

  /** set instance for access via {@link #getInstance()}. */
  private static void setInstance(final Activator instance) {
    s_instance = instance;
  }

  /**
   * {@inheritDoc}
   *
   * @see org.osgi.framework.BundleActivator#start(org.osgi.framework.BundleContext)
   */
  @Override
  public void start(final BundleContext context) throws Exception {
    setInstance(this);
    _bundleContext = context;
    _searchServiceTracker = new ServiceTracker<>(context, SearchService.class.getName(), null);
    _searchServiceTracker.open();
  }

  /**
   * {@inheritDoc}
   *
   * @see org.osgi.framework.BundleActivator#stop(org.osgi.framework.BundleContext)
   */
  @Override
  public void stop(final BundleContext context) throws Exception {
    setInstance(null);
  }

  /**
   * @return a currently available search service, or null if none is registered.
   */
  public SearchService getSearchService() {
    return _searchServiceTracker.getService();
  }

  /**
   * @return OSGI bundle context
   */
  public BundleContext getBundleContxt() {
    return _bundleContext;
  }

}
