/*********************************************************************************************************************
 * Copyright (c) 2008, 2015 Empolis Information Management GmbH and brox IT Solutions GmbH. All rights reserved.
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
**********************************************************************************************************************/
package org.eclipse.smila.solr.params;

import org.apache.solr.client.solrj.SolrRequest.METHOD;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.search.api.QueryConstants;
import org.eclipse.smila.solr.params.UpdateParams.Operation;

import junit.framework.TestCase;

public class ParamsHelper_Test extends TestCase {

  public void test_setSubParam() {
    final Record record = DataFactory.DEFAULT.createRecord();
    final AnyMap solrMap = record.getMetadata().getMap(SolrParams.SOLR_PARAMETER_ATTRIBUTE, true);
    final String subMapName = "subMap";
    final AnyMap subMap = solrMap.getMap(subMapName, true);
    final String key = "keyName";
    final String value = "thisIsTheValue";
    subMap.put(key, value);
    final Any result = ParamsHelper.setSubParam(record, subMapName, key, value);
    assertEquals(value, result.asValue().asString());
  }

  public void test_setSolrParam() {
    final Record record = DataFactory.DEFAULT.createRecord();
    final AnyMap solrMap = record.getMetadata().getMap(SolrParams.SOLR_PARAMETER_ATTRIBUTE, true);
    final String key = "keyName";
    final String value = "thisIsTheValue";
    solrMap.put(key, value);
    final Any result = ParamsHelper.setSolrParam(record, key, value);
    assertEquals(value, result.asValue().asString());
  }

  public void test_setRootParam() {
    final Record record = DataFactory.DEFAULT.createRecord();
    final String key = "keyName";
    final String value = "thisIsTheValue";
    record.getMetadata().put(key, value);
    final Any result = ParamsHelper.setRootParam(record, key, value);
    assertEquals(value, result.asValue().asString());
  }

  public void test_setUpdateAttachments() {
    final Record record = DataFactory.DEFAULT.createRecord();
    ParamsHelper.setUpdateAttachments(record, true);
    assertTrue(record.getMetadata().getMap(SolrParams.SOLR_PARAMETER_ATTRIBUTE).getMap(UpdateParams.UPDATE)
      .getBooleanValue(UpdateParams.ATTACHMENTS).booleanValue());
  }

  public void test_setUpdateCommitWithinMs() {
    final Record record = DataFactory.DEFAULT.createRecord();
    final int value = 23;
    ParamsHelper.setUpdateCommitWithinMs(record, value);
    assertEquals(value, record.getMetadata().getMap(SolrParams.SOLR_PARAMETER_ATTRIBUTE)
      .getMap(UpdateParams.UPDATE).getValue(UpdateParams.COMMIT_WITHIN_MS).asLong().intValue());
  }

  public void test_setUpdateDocumentBoost() {
    final Record record = DataFactory.DEFAULT.createRecord();
    final float value = 23.32f;
    ParamsHelper.setUpdateDocumentBoost(record, value);
    assertEquals(value, record.getMetadata().getMap(SolrParams.SOLR_PARAMETER_ATTRIBUTE)
      .getMap(UpdateParams.UPDATE).getValue(UpdateParams.DOCUMENT_BOOST).asDouble().floatValue());
  }

  public void test_setUpdateMapping() {
    final Record record = DataFactory.DEFAULT.createRecord();
    final AnyMap mapping = DataFactory.DEFAULT.createAnyMap();
    mapping.put("key", "data");
    ParamsHelper.setUpdateMapping(record, mapping);
    assertEquals(
      mapping,
      record.getMetadata().getMap(SolrParams.SOLR_PARAMETER_ATTRIBUTE).getMap(UpdateParams.UPDATE)
        .getMap(UpdateParams.MAPPING));
  }

  public void test_setUpdateOperation() {
    final Record record = DataFactory.DEFAULT.createRecord();
    final Operation operation = Operation.ADD;
    ParamsHelper.setUpdateOperation(record, operation);
    assertEquals(
      operation.name(),
      record.getMetadata().getMap(SolrParams.SOLR_PARAMETER_ATTRIBUTE).getMap(UpdateParams.UPDATE)
        .getStringValue(UpdateParams.OPERATION));
  }

  public void test_setUpdateDeleteQuery() {
    final Record record = DataFactory.DEFAULT.createRecord();
    final String query = "q=deleteQuery";
    ParamsHelper.setUpdateDeleteQuery(record, query);
    assertEquals(query, record.getMetadata().getMap(SolrParams.SOLR_PARAMETER_ATTRIBUTE)
      .getMap(UpdateParams.UPDATE).getStringValue(UpdateParams.DELETE_QUERY));
  }

  public void test_setUpdateIndexName() {
    final Record record = DataFactory.DEFAULT.createRecord();
    final String query = "q=deleteQuery";
    ParamsHelper.setUpdateIndexName(record, query);
    assertEquals(query, record.getMetadata().getStringValue(QueryConstants.INDEXNAME));
  }

  public void test_setSearchMethod() {
    final Record record = DataFactory.DEFAULT.createRecord();
    final METHOD method = METHOD.POST;
    ParamsHelper.setSearchMethod(record, method);
    assertEquals(
      method.name(),
      record.getMetadata().getMap(SolrParams.SOLR_PARAMETER_ATTRIBUTE).getMap(SearchParams.SEARCH)
        .getStringValue(SearchParams.HTTP_METHOD));
  }
  
  public void test_rootNull() {
    final AnyMap map = null;
    try {
      ParamsHelper.setRootParam(map, "key", "value");
    } catch (Exception e) {
      if (e instanceof IllegalArgumentException) {
        return;
      }
    }
    fail();
  }
  
  public void test_convertToAnyNull() {
    try {
      ParamsHelper.setRootParam(DataFactory.DEFAULT.createAnyMap(), null, "value");
    } catch (Exception e) {
      if (e instanceof IllegalArgumentException) {
        return;
      }
    }
    fail();
  }
  
  public void test_convertToAnyNull2() {
    try {
      ParamsHelper.setRootParam(DataFactory.DEFAULT.createAnyMap(), "key", null);
    } catch (Exception e) {
      if (e instanceof IllegalArgumentException) {
        return;
      }
    }
    fail();
  }

}
