/*********************************************************************************************************************
 * Copyright (c) 2008, 2015 Empolis Information Management GmbH and brox IT Solutions GmbH. All rights reserved.
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
**********************************************************************************************************************/
package org.eclipse.smila.solr.params;

import java.util.Arrays;

import junit.framework.TestCase;

import org.apache.solr.common.params.CommonParams;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.search.api.QueryConstants;
import org.eclipse.smila.solr.query.SolrQueryBuilder;

public class QueryParams_Test extends TestCase {

  private final static DataFactory _factory = DataFactory.DEFAULT;

  public void test_getStart() {
    final Record record = _factory.createRecord("getStart");
    final SolrQueryBuilder SolrQueryBuilder = new SolrQueryBuilder(record);
    SolrQueryBuilder.setOffset(11);
    final QueryParams queryParams = new QueryParams(null, record.getMetadata(), null);
    assertEquals(11, queryParams.getStart());
  }

  public void test_getStartDefault() {
    final Record record = _factory.createRecord("getStart");
    final QueryParams queryParams = new QueryParams(null, record.getMetadata(), null);
    assertEquals(QueryConstants.DEFAULT_OFFSET, queryParams.getStart());
  }

  public void test_getRows() {
    final Record record = _factory.createRecord("getRows");
    final SolrQueryBuilder SolrQueryBuilder = new SolrQueryBuilder(record);
    SolrQueryBuilder.setMaxCount(11);
    final QueryParams queryParams = new QueryParams(null, record.getMetadata(), null);
    assertEquals(11, queryParams.getRows());
  }

  public void test_getRowsDefault() {
    final Record record = _factory.createRecord("getRows");
    final QueryParams queryParams = new QueryParams(null, record.getMetadata(), null);
    assertEquals(QueryConstants.DEFAULT_MAXCOUNT, queryParams.getRows());
  }

  public void test_getFields() {
    final Record record = _factory.createRecord("getFields");
    final SolrQueryBuilder SolrQueryBuilder = new SolrQueryBuilder(record);
    SolrQueryBuilder.addResultAttributes("fieldName1", "fieldName1");
    SolrQueryBuilder.addResultAttributes("fieldName2");
    final QueryParams queryParams = new QueryParams(null, record.getMetadata(), null);
    assertEquals("[fieldName1, fieldName1, fieldName2]", Arrays.asList(queryParams.getFields()).toString());
  }

  public void test_getFieldsDefault() {
    final Record record = _factory.createRecord("getFields");
    final QueryParams queryParams = new QueryParams(null, record.getMetadata(), null);
    assertEquals("[]", Arrays.asList(queryParams.getFields()).toString());
  }

  public void test_getQueryObject() {
    final Record record = _factory.createRecord("getQueryObject");
    final SolrQueryBuilder SolrQueryBuilder = new SolrQueryBuilder(record);
    SolrQueryBuilder.setQuery("queryString");
    final QueryParams queryParams = new QueryParams(null, record.getMetadata(), null);
    assertEquals("queryString", queryParams.getQueryObject().toString());
  }

  public void test_getQueryObjectNull() {
    final Record record = _factory.createRecord("getQueryObject");
    final QueryParams queryParams = new QueryParams(null, record.getMetadata(), null);
    assertNull(queryParams.getQueryObject());
  }

  public void test_getNativeParams() {
    final Record record = _factory.createRecord("getNativeParams");
    final SolrQueryBuilder SolrQueryBuilder = new SolrQueryBuilder(record);
    SolrQueryBuilder.setNative("param1", "value1");
    SolrQueryBuilder.setNative("param2", "value2");
    final QueryParams queryParams = new QueryParams(null, record.getMetadata(), null);
    assertEquals("{param1=value1, param2=value2}", queryParams.getNativeParams().toString());
  }

  public void test_getNativeParamsNull() {
    final Record record = _factory.createRecord("getNativeParams");
    final QueryParams queryParams = new QueryParams(null, record.getMetadata(), null);
    assertNull(queryParams.getNativeParams());
  }

  public void test_getRequestHandler() {
    final Record record = _factory.createRecord("getRequestHandler");
    final SolrQueryBuilder SolrQueryBuilder = new SolrQueryBuilder(record);
    SolrQueryBuilder.setNative(CommonParams.QT, "value1");
    final QueryParams queryParams = new QueryParams(null, record.getMetadata(), null);
    assertEquals("value1", queryParams.getRequestHandler());
  }

  public void test_getRequestHandlerNull() {
    final Record record = _factory.createRecord("getRequestHandler");
    final QueryParams queryParams = new QueryParams(null, record.getMetadata(), null);
    assertNull(queryParams.getRequestHandler());
  }

}
