/*********************************************************************************************************************
 * Copyright (c) 2008, 2015 Empolis Information Management GmbH and brox IT Solutions GmbH. All rights reserved.
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
**********************************************************************************************************************/
package org.eclipse.smila.solr.params;

import junit.framework.TestCase;

import org.apache.solr.client.solrj.SolrRequest.METHOD;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.solr.SolrConstants.ErrorHandling;
import org.eclipse.smila.solr.SolrConstants.QueryLogging;

public class SearchParams_Test extends TestCase {

  public void test_getMethod1() {
    final AnyMap config = DataFactory.DEFAULT.createAnyMap();
    config.getMap(SearchParams.SEARCH, true);
    final SearchParams searchParams = new SearchParams(config);
    final METHOD method = searchParams.getMethod();
    assertEquals(METHOD.POST.toString(), method.toString());
  }

  public void test_getMethod2() {
    final AnyMap config = DataFactory.DEFAULT.createAnyMap();
    final AnyMap search = config.getMap(SearchParams.SEARCH, true);
    search.put(SearchParams.HTTP_METHOD, METHOD.POST.toString());
    final SearchParams searchParams = new SearchParams(config);
    final METHOD method = searchParams.getMethod();
    assertEquals(METHOD.POST.toString(), method.toString());
  }

  public void test_getMethod3() {
    final AnyMap config = DataFactory.DEFAULT.createAnyMap();
    final AnyMap search = config.getMap(SearchParams.SEARCH, true);
    search.put(SearchParams.HTTP_METHOD, "any");
    final SearchParams searchParams = new SearchParams(config);
    try {
      searchParams.getMethod();
    } catch (final Exception e) {
      if (e instanceof IllegalArgumentException) {
        return;
      }
    }
    fail();
  }

  public void test_getErrorHandling() {
    final AnyMap config = DataFactory.DEFAULT.createAnyMap();
    final AnyMap search = config.getMap(SearchParams.SEARCH, true);
    final ErrorHandling errorHandling = ErrorHandling.THROW;
    search.put(SearchParams.ERROR_HANDLING, errorHandling.name());
    final SearchParams searchParams = new SearchParams(config);
    assertEquals(errorHandling, searchParams.getErrorHandling());
  }

  public void test_getErrorHandlingDefault() {
    final AnyMap config = DataFactory.DEFAULT.createAnyMap();
    final SearchParams searchParams = new SearchParams(config);
    assertEquals(ErrorHandling.IGNORE, searchParams.getErrorHandling());
  }

  public void test_getErrorHandlingError() {
    final AnyMap config = DataFactory.DEFAULT.createAnyMap();
    final AnyMap search = config.getMap(SearchParams.SEARCH, true);
    search.put(SearchParams.ERROR_HANDLING, "any");
    final SearchParams searchParams = new SearchParams(config);
    try {
      searchParams.getErrorHandling();
    } catch (final Exception e) {
      if (e instanceof IllegalArgumentException) {
        return;
      }
    }
    fail();
  }

  public void test_getQueryLogging() {
    final AnyMap config = DataFactory.DEFAULT.createAnyMap();
    final AnyMap search = config.getMap(SearchParams.SEARCH, true);
    final QueryLogging queryLogging = QueryLogging.BOTH;
    search.put(SearchParams.QUERY_LOGGING, queryLogging.name());
    final SearchParams searchParams = new SearchParams(config);
    assertEquals(queryLogging, searchParams.getQueryLogging());
  }

  public void test_getQueryLoggingDefault() {
    final AnyMap config = DataFactory.DEFAULT.createAnyMap();
    final SearchParams searchParams = new SearchParams(config);
    assertEquals(QueryLogging.NONE, searchParams.getQueryLogging());
  }

  public void test_getQueryLoggingError() {
    final AnyMap config = DataFactory.DEFAULT.createAnyMap();
    final AnyMap search = config.getMap(SearchParams.SEARCH, true);
    search.put(SearchParams.QUERY_LOGGING, "any");
    final SearchParams searchParams = new SearchParams(config);
    try {
      searchParams.getQueryLogging();
    } catch (final Exception e) {
      if (e instanceof IllegalArgumentException) {
        return;
      }
    }
    fail();
  }
}
