/*********************************************************************************************************************
 * Copyright (c) 2008, 2015 Empolis Information Management GmbH and brox IT Solutions GmbH. All rights reserved.
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
**********************************************************************************************************************/
package org.eclipse.smila.solr.search;

import junit.framework.TestCase;

import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.solr.SolrConstants;
import org.eclipse.smila.solr.params.SolrParams;

public class ResponseAccessor_Test extends TestCase {

  public void test_getResponseHeader() {
    final Record record = DataFactory.DEFAULT.createRecord();
    final AnyMap responseHeader =
      record.getMetadata().getMap(SolrParams.SOLR_PARAMETER_ATTRIBUTE, true)
        .getMap(ResponseAccessor.RESPONSE, true).getMap(SolrConstants.RESPONSE_HEADER, true);
    final ResponseAccessor sra = new ResponseAccessor(record);
    assertEquals(responseHeader, sra.getResponseHeader());
  }

  public void test_getStatus() {
    final Record record = DataFactory.DEFAULT.createRecord();
    final AnyMap responseHeader =
      record.getMetadata().getMap(SolrParams.SOLR_PARAMETER_ATTRIBUTE, true)
        .getMap(ResponseAccessor.RESPONSE, true).getMap(SolrConstants.RESPONSE_HEADER, true);
    responseHeader.put(SolrConstants.STATUS, "7");
    final ResponseAccessor sra = new ResponseAccessor(record);
    assertEquals(7, sra.getStatus().intValue());
  }

  public void test_getStatusNull() {
    final Record record = DataFactory.DEFAULT.createRecord();
    record.getMetadata().getMap(SolrParams.SOLR_PARAMETER_ATTRIBUTE, true).getMap(ResponseAccessor.RESPONSE, true)
      .getMap(SolrConstants.RESPONSE_HEADER, true);
    final ResponseAccessor sra = new ResponseAccessor(record);
    assertNull(sra.getStatus());
  }

  public void test_getQTime() {
    final Record record = DataFactory.DEFAULT.createRecord();
    final AnyMap responseHeader =
      record.getMetadata().getMap(SolrParams.SOLR_PARAMETER_ATTRIBUTE, true)
        .getMap(ResponseAccessor.RESPONSE, true).getMap(SolrConstants.RESPONSE_HEADER, true);
    responseHeader.put(SolrConstants.Q_TIME, "7");
    final ResponseAccessor sra = new ResponseAccessor(record);
    assertEquals(7, sra.getQTime().intValue());
  }

  public void test_getQTimeNull() {
    final Record record = DataFactory.DEFAULT.createRecord();
    record.getMetadata().getMap(SolrParams.SOLR_PARAMETER_ATTRIBUTE, true).getMap(ResponseAccessor.RESPONSE, true)
      .getMap(SolrConstants.RESPONSE_HEADER, true);
    final ResponseAccessor sra = new ResponseAccessor(record);
    assertNull(sra.getQTime());
  }

  public void test_getMaxScore() {
    final Record record = DataFactory.DEFAULT.createRecord();
    final AnyMap responseHeader =
      record.getMetadata().getMap(SolrParams.SOLR_PARAMETER_ATTRIBUTE, true)
        .getMap(ResponseAccessor.RESPONSE, true).getMap(SolrConstants.RESPONSE_HEADER, true);
    responseHeader.put(SolrConstants.MAX_SCORE, "7");
    final ResponseAccessor sra = new ResponseAccessor(record);
    assertEquals(7, sra.getMaxScore().intValue());
  }

  public void test_getMaxScoreNull() {
    final Record record = DataFactory.DEFAULT.createRecord();
    record.getMetadata().getMap(SolrParams.SOLR_PARAMETER_ATTRIBUTE, true).getMap(ResponseAccessor.RESPONSE, true)
      .getMap(SolrConstants.RESPONSE_HEADER, true);
    final ResponseAccessor sra = new ResponseAccessor(record);
    assertNull(sra.getMaxScore());
  }

  public void test_getParams() {
    final Record record = DataFactory.DEFAULT.createRecord();
    final AnyMap responseHeader =
      record.getMetadata().getMap(SolrParams.SOLR_PARAMETER_ATTRIBUTE, true)
        .getMap(ResponseAccessor.RESPONSE, true).getMap(SolrConstants.RESPONSE_HEADER, true);
    final AnySeq params = responseHeader.getSeq(SolrConstants.PARAMS, true);
    final ResponseAccessor sra = new ResponseAccessor(record);
    assertEquals(params, sra.getParams());
  }

  public void test_getParamsNull() {
    final Record record = DataFactory.DEFAULT.createRecord();
    record.getMetadata().getMap(SolrParams.SOLR_PARAMETER_ATTRIBUTE, true).getMap(ResponseAccessor.RESPONSE, true)
      .getMap(SolrConstants.RESPONSE_HEADER, true);
    final ResponseAccessor sra = new ResponseAccessor(record);
    assertNull(sra.getParams());
  }

  public void test_getTerms() {
    final Record record = DataFactory.DEFAULT.createRecord();
    final AnyMap response =
      record.getMetadata().getMap(SolrParams.SOLR_PARAMETER_ATTRIBUTE, true)
        .getMap(ResponseAccessor.RESPONSE, true);
    final AnyMap terms = response.getMap(SolrConstants.TERMS, true);
    final ResponseAccessor sra = new ResponseAccessor(record);
    assertEquals(terms, sra.getTerms());
  }

  public void test_getSpellcheck() {
    final Record record = DataFactory.DEFAULT.createRecord();
    final AnyMap response =
      record.getMetadata().getMap(SolrParams.SOLR_PARAMETER_ATTRIBUTE, true)
        .getMap(ResponseAccessor.RESPONSE, true);
    final AnyMap spellcheck = response.getMap(SolrConstants.SPELLCHECK, true);
    final ResponseAccessor sra = new ResponseAccessor(record);
    assertEquals(spellcheck, sra.getSpellcheck());
  }

  public void test_getMoreLikeThis() {
    final Record record = DataFactory.DEFAULT.createRecord();
    final AnyMap response =
      record.getMetadata().getMap(SolrParams.SOLR_PARAMETER_ATTRIBUTE, true)
        .getMap(ResponseAccessor.RESPONSE, true);
    final AnyMap mlt = response.getMap(SolrConstants.MORE_LIKE_THIS, true);
    final ResponseAccessor sra = new ResponseAccessor(record);
    assertEquals(mlt, sra.getMoreLikeThis());
  }

  public void test_getNextCursorMark() {
    final Record record = DataFactory.DEFAULT.createRecord();
    final AnyMap response =
      record.getMetadata().getMap(SolrParams.SOLR_PARAMETER_ATTRIBUTE, true)
        .getMap(ResponseAccessor.RESPONSE, true);
    response.put(SolrConstants.NEXT_CURSOR_MARK, "3");
    final ResponseAccessor sra = new ResponseAccessor(record);
    assertEquals("3", sra.getNextCursorMark());
  }

  public void test_getDebug() {
    final Record record = DataFactory.DEFAULT.createRecord();
    final AnyMap response =
      record.getMetadata().getMap(SolrParams.SOLR_PARAMETER_ATTRIBUTE, true)
        .getMap(ResponseAccessor.RESPONSE, true);
    final AnyMap debug = response.getMap(SolrConstants.DEBUG, true);
    final ResponseAccessor sra = new ResponseAccessor(record);
    assertEquals(debug, sra.getDebug());
  }

  public void test_getStats() {
    final Record record = DataFactory.DEFAULT.createRecord();
    final AnyMap response =
      record.getMetadata().getMap(SolrParams.SOLR_PARAMETER_ATTRIBUTE, true)
        .getMap(ResponseAccessor.RESPONSE, true);
    final AnyMap stats = response.getMap(SolrConstants.STATS, true);
    final ResponseAccessor sra = new ResponseAccessor(record);
    assertEquals(stats, sra.getStats());
  }
}
