/*********************************************************************************************************************
 * Copyright (c) 2008, 2015 Empolis Information Management GmbH and brox IT Solutions GmbH. All rights reserved.
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
**********************************************************************************************************************/
package org.eclipse.smila.solr.server;

import org.apache.solr.client.solrj.SolrServerException;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.solr.SolrConfig;

import junit.framework.TestCase;

public class CloudServers_Test extends TestCase {
  
  public void test_getServer() throws SolrServerException {
    final AnyMap config = DataFactory.DEFAULT.createAnyMap();
    config.put(SolrConfig.ZK_HOST, "http://localhost:8983/solr");
    final SolrServers solrServer = new CloudServers(new SolrConfig(config));
    solrServer.getServer();
  }
  
  public void test_getServer2() throws SolrServerException {
    final AnyMap config = DataFactory.DEFAULT.createAnyMap();
    config.put(SolrConfig.ZK_HOST, "http://localhost:8983/solr");
    final SolrServers solrServer = new CloudServers(new SolrConfig(config));
    solrServer.getServer("index");
  }
  
  public void test_getServer3() throws SolrServerException {
    final AnyMap config = DataFactory.DEFAULT.createAnyMap();
    final SolrServers solrServer = new CloudServers(new SolrConfig(config));
    try {
      solrServer.getServer("index");
    } catch (Exception e) {
      if (e instanceof SolrServerException) {
        return;
      }
    }
    fail();
  }
}
