/*********************************************************************************************************************
 * Copyright (c) 2008, 2012 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 **********************************************************************************************************************/
package org.eclipse.smila.solr.test;

import junit.framework.Test;
import junit.framework.TestSuite;

import org.eclipse.smila.solr.SolrConfig_Test;
import org.eclipse.smila.solr.SolrUtils_Test;
import org.eclipse.smila.solr.params.ParamsHelper_Test;
import org.eclipse.smila.solr.params.QueryParams_Test;
import org.eclipse.smila.solr.params.SearchParams_Test;
import org.eclipse.smila.solr.params.SolrParams_Test;
import org.eclipse.smila.solr.params.UpdateParams_Test;
import org.eclipse.smila.solr.query.QueryTransformer_Test;
import org.eclipse.smila.solr.query.SolrQueryBuilder_Test;
import org.eclipse.smila.solr.search.ResponseAccessor_Test;
import org.eclipse.smila.solr.search.SolrResponseParser_Test;
import org.eclipse.smila.solr.server.CloudServers_Test;
import org.eclipse.smila.solr.server.HttpServers_Test;
import org.eclipse.smila.solr.update.SolrDocumentConverter_Test;

/**
 * @author tmenzel this just exists so that the default test.xml during the build is happy.
 */
public class AllTests {

  public static Test suite() {
    final TestSuite suite = new TestSuite(AllTests.class.getName());
    // $JUnit-BEGIN$
    suite.addTestSuite(SolrDocumentConverter_Test.class);
    suite.addTestSuite(SolrConfig_Test.class);
    suite.addTestSuite(UpdateParams_Test.class);
    suite.addTestSuite(SolrParams_Test.class);
    suite.addTestSuite(SolrQueryBuilder_Test.class);
    suite.addTestSuite(SolrUtils_Test.class);
    suite.addTestSuite(QueryParams_Test.class);
    suite.addTestSuite(QueryTransformer_Test.class);
    suite.addTestSuite(SolrUtils_Test.class);
    suite.addTestSuite(SolrResponseParser_Test.class);
    suite.addTestSuite(SearchParams_Test.class);
    suite.addTestSuite(ParamsHelper_Test.class);
    suite.addTestSuite(ResponseAccessor_Test.class);
    suite.addTestSuite(HttpServers_Test.class);
    suite.addTestSuite(CloudServers_Test.class);
    // $JUnit-END$
    return suite;
  }
}
