/*********************************************************************************************************************
 * Copyright (c) 2008, 2015 Empolis Information Management GmbH and brox IT Solutions GmbH. All rights reserved.
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
**********************************************************************************************************************/
package org.eclipse.smila.solr.administration;

import org.apache.commons.lang.ArrayUtils;
import org.eclipse.smila.datamodel.Any.ValueType;
import org.eclipse.smila.datamodel.AnyMap;

public class FieldInfo {

  public static final String NAME = "name";

  public static final String TYPE = "type";

  public static final String DEFAULT = "default";

  public static final String INDEXED = "indexed";

  public static final String STORED = "stored";

  public static final String DOC_VALUES = "docValues";

  public static final String SORT_MISSING_FIRST = "sortMissingFirst";

  public static final String SORT_MISSING_LAST = "sortMissingLast";

  public static final String MULTIVALUED = "multiValued";

  public static final String OMIT_NORMS = "omitNorms";

  public static final String OMIT_TERM_FREQ_AND_POSITION = "omitTermFreqAndPosition";

  public static final String OMIT_POSITION = "omitPosition";

  public static final String TERM_VECTORS = "termVectors";

  public static final String TERM_POSITIONS = "termPositions";

  public static final String TERM_OFFSETS = "termOffsets";

  public static final String REQUIRED = "required";

  private final AnyMap _field;

  public FieldInfo(final AnyMap field) {
    _field = field;
  }

  public String getName() {
    return _field.getStringValue(NAME);
  }

  public String getType() {
    return _field.getStringValue(TYPE);
  }

  public String getDefault() {
    return _field.getStringValue(DEFAULT);
  }

  public Boolean isIndexed() {
    return _field.getBooleanValue(INDEXED);
  }

  public Boolean isStored() {
    return _field.getBooleanValue(STORED);
  }

  public Boolean isDocValues() {
    return _field.getBooleanValue(DOC_VALUES);
  }

  public Boolean isSortMissingFirst() {
    return _field.getBooleanValue(SORT_MISSING_FIRST);
  }

  public Boolean isSortMissingLast() {
    return _field.getBooleanValue(SORT_MISSING_LAST);
  }

  public Boolean isMultiValued() {
    return _field.getBooleanValue(MULTIVALUED);
  }

  public Boolean isOmitNorms() {
    return _field.getBooleanValue(OMIT_NORMS);
  }

  public Boolean isOmitTermFreqAndPosition() {
    return _field.getBooleanValue(OMIT_TERM_FREQ_AND_POSITION);
  }

  public Boolean isOmitPositions() {
    return _field.getBooleanValue(OMIT_POSITION);
  }

  public Boolean isTermVectors() {
    return _field.getBooleanValue(TERM_VECTORS);
  }

  public Boolean isTermPositions() {
    return _field.getBooleanValue(TERM_POSITIONS);
  }

  public Boolean isTermOffsets() {
    return _field.getBooleanValue(TERM_OFFSETS);
  }

  public Boolean isRequired() {
    return _field.getBooleanValue(REQUIRED);
  }

  public static final String[] LONGS = { "int", "short", "long" };

  public static final String[] DOUBLES = { "float", "double" };

  public static final String[] DATES = { "date" };

  public static final String[] BOOLEANS = { "boolean" };

  public ValueType getTypeAsValueType() {
    final String type = getType();
    if (ArrayUtils.contains(LONGS, type)) {
      return ValueType.LONG;
    } else if (ArrayUtils.contains(DOUBLES, type)) {
      return ValueType.DOUBLE;
    } else if (ArrayUtils.contains(DATES, type)) {
      return ValueType.DATETIME;
    } else if (ArrayUtils.contains(BOOLEANS, type)) {
      return ValueType.BOOLEAN;
    }
    return ValueType.STRING;
  }

}
