/**
 *
 */
package org.eclipse.smila.solr.administration;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.httpclient.HttpException;
import org.apache.solr.common.params.CommonParams;
import org.apache.solr.schema.IndexSchema;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.solr.SolrOperationService;
import org.eclipse.smila.utils.service.ServiceUtils;

/**
 * @author pwissel
 *
 */
public class FieldInfoCache {

  public static final String PARAM_INCLUDE_DYNAMIC = "includeDynamic";

  final static Map<String, Map<String, FieldInfo>> _fieldInfo = new HashMap<String, Map<String, FieldInfo>>();

  public static Map<String, FieldInfo> getFieldInfo(final String index) {
    Map<String, FieldInfo> fieldInfo = _fieldInfo.get(index);
    if (fieldInfo == null) {
      fieldInfo = new HashMap<String, FieldInfo>();
      _fieldInfo.put(index, fieldInfo);
    }
    return fieldInfo;
  }

  public static FieldInfo getFieldInfo(final String index, final String fieldName) throws HttpException,
    InterruptedException, IOException {
    FieldInfo fieldInfo = getFieldInfo(index).get(fieldName);
    if (fieldInfo == null) {
      fieldInfo = getFromSchema(index, fieldName);
      if (fieldInfo != null) {
        getFieldInfo(index).put(fieldName, fieldInfo);
      }
    }
    return fieldInfo;
  }

  private static FieldInfo getFromSchema(final String index, final String fieldName) throws InterruptedException,
    HttpException, IOException {
    final SolrOperationService service = ServiceUtils.getService(SolrOperationService.class);
    // add parameter
    final Map<String, String[]> params = new HashMap<String, String[]>();
    params.put(CommonParams.FL, new String[] { fieldName });
    params.put(PARAM_INCLUDE_DYNAMIC, new String[] { Boolean.toString(true) });
    // add path
    final List<String> path = new ArrayList<String>();
    path.add(IndexSchema.SCHEMA);
    path.add(IndexSchema.FIELDS);
    final Any response = service.processSchemaRequest(index, params, path);
    if (response instanceof AnyMap) {
      final AnyMap field = ((AnyMap) response).getSeq(IndexSchema.FIELDS).getMap(0);
      return new FieldInfo(field);
    }
    return null;
  }

}
