/*********************************************************************************************************************
 * Copyright (c) 2008, 2015 Empolis Information Management GmbH and brox IT Solutions GmbH. All rights reserved.
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
**********************************************************************************************************************/
package org.eclipse.smila.solr.administration;

import java.util.Map;
import java.util.Map.Entry;

import org.apache.commons.collections.MapUtils;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

public class SmilaCoreAdminRequest extends CoreAdminRequest {

  private static final long serialVersionUID = 1L;

  final ModifiableSolrParams _params = new ModifiableSolrParams();

  public SmilaCoreAdminRequest(final String action) {
    this(action, null);
  }

  public SmilaCoreAdminRequest(final String action, final Map<String, String[]> params) {
    _params.set(CollectionParams.ACTION, action);
    if (!MapUtils.isEmpty(params)) {
      for (final Entry<String, String[]> param : params.entrySet()) {
        _params.set(param.getKey(), param.getValue());
      }
    }
  }

  @Override
  public SolrParams getParams() {
    return _params;
  }
}
