/**
 *
 */
package org.eclipse.smila.solr.httphandler;

import java.util.List;
import java.util.Map;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.common.params.CollectionParams.CollectionAction;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.http.server.HttpExchange;
import org.eclipse.smila.http.server.json.JsonRequestHandler;
import org.eclipse.smila.http.server.util.UnsupportedMethodException;
import org.eclipse.smila.solr.SolrOperationService;

/**
 * @author pwissel
 *
 */
public abstract class AAdminHandler extends JsonRequestHandler {

  private final Log _log = LogFactory.getLog(getClass());

  protected SolrOperationService _operationService;

  @Override
  public Object process(final String method, final String requestUri, Record inputRecord,
    final HttpExchange exchange) throws Exception {
    // TODO: allow handler only if static uri part match mode configuration
    Any result = null;
    switch (method) {
      case "GET":
        result = doGet(exchange, requestUri);
        break;
      case "POST":
        result = doPost(exchange, requestUri);
        break;
      default:
        throw new UnsupportedMethodException("HttpMethod: [GET, POST]");
    }
    return result;
  }

  abstract Any doGet(final HttpExchange exchange, final String requestUri) throws Exception;

  Any doPost(final HttpExchange exchange, final String requestUri) throws Exception {
    final String action = getAction(requestUri);
    final Map<String, String[]> params = exchange.getParameterMap();
    return _operationService.processAdminOperation(action, params);
  }

  protected String getStaticUriPart(final String requestUri) {
    return getDynamicUriParts(requestUri).get(0);
  }

  protected String getAction(final String requestUri) {
    final List<String> dynamicUriParts = getDynamicUriParts(requestUri);
    if (dynamicUriParts.size() <= 1) {
      final String message =
        String.format("Action must be part of the uri. One of [%s]",
          StringUtils.join(CollectionAction.values(), ','));
      throw new IllegalArgumentException(message);
    }
    return dynamicUriParts.get(1);
  }

  @Override
  protected boolean isValidMethod(final String method, final String requestUri) {
    return "POST".equals(method) || "GET".equals(method);
  }

  protected void bindSolrOperationService(final SolrOperationService operationService) {
    if (_log.isDebugEnabled()) {
      _log.debug("Bind SolrOperationService...");
    }
    _operationService = operationService;
  }

  protected void unbindSolrOperationService(final SolrOperationService operationService) {
    if (_operationService == operationService) {
      if (_log.isDebugEnabled()) {
        _log.debug("Unbind SolrOperationService...");
      }
      _operationService = null;
    }
  }

}
